#include <stdio.h>
#include <unistd.h>
#include "fdsclientlib.h"

#include <stdlib.h>
#include <string.h>

void sillymessage(int socket_fd)
{
	int hdr[4] = {3, 0, 0, 0};
	char buffer[256];

	write(socket_fd, hdr, sizeof(hdr));
	int nbytes = sprintf(buffer, "hello from a client");
	write(socket_fd, buffer, nbytes);
	
	nbytes = read(socket_fd, buffer, 256);
	buffer[nbytes] = 0;

	printf("MESSAGE FROM SERVER: %s\n", buffer);
}

int main(void)
{
	char *homedir = getenv("HOME");
	const char *sockrelpath = "/.local/fdsserver-socket";

	int fulllen = strlen(homedir) + strlen(sockrelpath);
	char *fullpath = (char*)malloc(fulllen+1);

	strncpy(fullpath, homedir, fulllen);
	strncat(fullpath, sockrelpath, fulllen);
	fullpath[fulllen]='\0';

	char buffer[256];

	int socket_fd = FDS_connect(fullpath);

	if(0 > socket_fd)
	{
		printf("connect() failed\n");
		return 1;
	}

	char *cwd=(char*)malloc(strlen(getenv("PWD")+2));
	sprintf(cwd, "%s/", getenv("PWD"));
	FDS_chroot(socket_fd, cwd);

	sillymessage(socket_fd);

	int readFd = FDS_open(socket_fd,"aa.txt", O_RDONLY);

	if (readFd < 0)
		printf("fd recieve failed with %d\n", readFd);
	else
	{
		int nbytes = read(readFd, buffer, 255);
		buffer[nbytes] = 0;
		printf("file contents: %s\n", buffer);
	}

	FDS_disconnect(socket_fd);
	close(readFd);

	return 0;
}
