{-# LANGUAGE CPP, ForeignFunctionInterface, OverloadedStrings #-}


module System.Fdsclient (
 fds_connect,
 fds_disconnect,
 fds_chroot,
 fds_open
 ) where

import Data.Bits((.|.))
import Data.ByteString.Char8(pack, useAsCString)
import System.Fdsclient.Raw
import System.Posix.IO(OpenMode(..), OpenFileFlags(..))
import System.Posix.Types(Fd(..),FileMode)
import Control.Monad(liftM)

fds_connect :: FilePath -> IO Fd
fds_connect path = liftM Fd $ useAsCString (pack path) c_FDS_connect

fds_disconnect :: Fd -> IO ()
fds_disconnect (Fd x) = c_FDS_disconnect x

fds_chroot :: Fd -> FilePath -> IO Int
fds_chroot (Fd socket) path = liftM fromIntegral $ useAsCString (pack path) (c_FDS_chroot socket)

#include <fcntl.h>

fds_open :: Fd -> FilePath -> OpenMode -> Maybe FileMode -> OpenFileFlags -> IO Fd
fds_open (Fd socket) path mode filemode openFileFlags = liftM Fd $ useAsCString (pack path) (\a -> c_FDS_open socket a all_flags  (fromIntegral mode_w))
  where
    all_flags  = creat .|. flags .|. open_mode

    flags =
       (if (append openFileFlags)    then (#const O_APPEND)   else 0) .|.
       (if (exclusive openFileFlags) then (#const O_EXCL)     else 0) .|.
       (if (noctty openFileFlags)    then (#const O_NOCTTY)   else 0) .|.
       (if (nonBlock openFileFlags)  then (#const O_NONBLOCK) else 0) .|.
       (if (trunc openFileFlags)  then (#const O_TRUNC)    else 0)
    
    (creat, mode_w) = case filemode of 
                Nothing -> (0,0)
                Just x  -> ((#const O_CREAT), x)

    open_mode = case mode  of
           ReadOnly  -> (#const O_RDONLY)
           WriteOnly -> (#const O_WRONLY)
           ReadWrite -> (#const O_RDWR)





