function [outsig,aatt]=dafx_maxlim(x,threshold,arel,N,navg)
%function [outsig,aatt]=dafx_maxlim(x,threshold,arel,N,navg)
navg=max(1,navg);
%threshold=0.5;
M=length(x);
T=M/10;
%basic limiter using an envelope detection method

%compute attack constant
%detector filter output: y(n)=yt+(y0-yt)*(1-a)^n
%yt=target, y0=current, n=time
%error e=yt-y(n)
%
%ratio between the error and the difference between the start and target values:
%r=e/(yt-y0)=(1-a)^n
%
%r is fixed to some maximum error and a is solved: a=1-exp(log(r)/N)
%the safety gain at limiter output: gs=1-r

alpha=1.01;

%note that the requirements are more tight if averaging post-filtering is used, 
%the control signal must rise to xmax in N-navg samples
aatt=1-exp(log((alpha-1)/alpha)/(N+1));
beta=0;
for i=0:navg-1,
   beta=beta+(1-aatt)^(N+1-i);
end
beta=beta/navg;
%aatt=arel;

%full-wave rectify
xabs=abs(x);
xmax=x*0;
c=xabs;
      
%control signal
e=xabs*0;
emax=xabs*0;

for n=N+1:M,
   c(n)=max(xabs(n),(xabs(n)-e(n-1)*beta)/(1-beta));
 	xmax(n)=max(c(n-N:n));
   target=xmax(n); %use maxfilter output as target
   if (target>e(n-1)),
      a=aatt;
   else
      a=arel;
   end
   emax(n)=a*target+(1-a)*emax(n-1);
   e(n)=sum(emax(n-navg+1:n))/navg;   
end

%averaging filter
%if navg>0,
%   avge=e;
%	for n=navg+1:M,
%      avge(n)=sum(e(n-navg:n))/(navg+1);
%   end
%   e=avge;
%end

%gain processor
y=xabs*0;
for n=N+1:M,
   g(n)=min(1,threshold/(e(n)));
   y(n)=g(n)*x(n-N);
end

clf;
subplot(3,1,1);
hold on;
plot(x(1:M));
plot([1,M],[1,1]*threshold,':');
h=text(10,0.6,'threshold');
set(h,'fontsize',12);
hold off;

subplot(3,1,2);
hold on;
%plot(xabs(1:M));  %makes the plot quite crowded
plot(xmax(1:M),':');
plot(e(1:M));
h=text(T*6.7,0.27,'xmax(n)');
set(h,'fontsize',12);
h=text(T*8,e(T*8)+0.05,'e(n)');
set(h,'fontsize',12);
hold off;

subplot(3,1,3);
hold on;
plot(y(2:M));
plot([1,M],[1,1]*threshold,':');
h=text(10,0.6,'threshold');
set(h,'fontsize',12);
hold off;


subplot(3,1,1);
ylabel('x(n)','fontsize',12);
ax=axis;
ax(3)=min(min(x),0);
ax(4)=1;
axis(ax);

subplot(3,1,2);
ylabel('xmax(n), e(n)','fontsize',12);
ax=axis;
ax(3:4)=[0,1];
axis(ax);

subplot(3,1,3);
ylabel('y(n)','fontsize',12);
xlabel('samples','fontsize',12);
ax=axis;
ax(4)=1;
axis(ax);


outsig=zeros(M,4);
outsig(1:M,1)=y;
outsig(1:M,2)=xabs;
outsig(1:M,3)=xmax;
outsig(1:M,4)=e;
