function [y]=basicLimiter2(x,delay)
%function [y]=basicLimiter2(x,delay)

N=delay
M=length(x);
T=M/10;

threshold=0.5;
aatt=0.2;
arel=0.01;

absx=abs(x);
%maxx=x;
%for n=1:M,
%   maxx(n)=max(absx(n:min(M,n+N)));
%end

e(1)=abs(x(1));
for n=2:M,
   %target=maxx(n); %use maxfilter output as target
   target=absx(n); %use abs(x(n)) as target
   if (target>e(n-1)),
      a=aatt;
   else
      a=arel;
   end
   e(n)=a*target+(1-a)*e(n-1);
end

for n=N+1:M,
   g(n)=min(1,threshold/e(n));
   y(n)=g(n)*x(n-N);
end

clf;
subplot(3,1,1);
hold on;
plot(x(2:M));
plot([1,M],[1,1]*threshold,':');
h=text(10,0.6,'threshold');
set(h,'fontsize',12);
hold off;

subplot(3,1,2);
hold on;
plot(absx(2:M));
%plot(maxx(2:M),'g');
plot(e(2:M));
h=text(T*6.7,0.27,'|x(n)|');
set(h,'fontsize',12);
h=text(T*8,e(T*8)+0.05,'e(n)');
set(h,'fontsize',12);
hold off;

subplot(3,1,3);
hold on;
plot(y(2:M));
plot([1,M],[1,1]*threshold,':');
h=text(10,0.6,'threshold');
set(h,'fontsize',12);
hold off;


subplot(3,1,1);
ylabel('x(n)','fontsize',12);
ax=axis;
ax(3)=min(min(x),0);
ax(4)=1;
axis(ax);

subplot(3,1,2);
ylabel('|x(n)|, e(n)','fontsize',12);
ax=axis;
ax(3:4)=[0,1];
axis(ax);

subplot(3,1,3);
ylabel('y(n)','fontsize',12);
xlabel('samples','fontsize',12);
ax=axis;
ax(4)=1;
axis(ax);
