function nnets = fbmmlp2nnet(fbm)
%FBMMLP2NNET Convert FBM-generated MLPs into nnet-toolbox 3.x or 4.x format
%
%   NNETS = FBMMLP2NNET(FBM)
%   returns cell array of networks created out of simulated
%   networks in FBM-structure. 
%
%   Requires Mathworks Neural Network Toolbox 3.x or 4.x
%
%   See also
%     FBMMLPREAD
%     THIN

% Copyright (C) 1999 Simo Srkk
% Copyright (C) 2003 Aki Vehtari
%
% This software is distributed under the GNU General Public 
% Licence (version 2 or later); please refer to the file 
% Licence.txt, included with the software, for details.

% Number of networks
n=size(fbm.inputWeights,1);

% Determine number of inputs/hidden/outputs
hidden  = fbm.numHidden;
outputs = fbm.numOutputs;
inputs  = fbm.numInputs;

% Convert the networks
funs = {};
for i=1:fbm.numLayers
  funs{i} = 'tansig';
end
funs{fbm.numLayers+1} = 'purelin';
units = [hidden outputs];
nnets = cell(1,n);
tmpnet = nnetff(repmat([-1 1],inputs,1),units,funs,'trainscg');
k = 1;
for i=1:n
  iw = reshape(fbm.inputWeights(i,:),hidden,inputs);
  ib = reshape(fbm.inputBiases(i,:),hidden,1);
  nnets{k} = tmpnet;
  nnets{k}.IW{1} = iw;
  nnets{k}.b{1}  = ib;
  for j=1:fbm.numLayers
    lw = fbm.layerWeights{j};
    lb = fbm.layerBiases{j};
    lw = reshape(lw(i,:),outputs,hidden);
    lb = reshape(lb(i,:),outputs,1);
    nnets{k}.LW{j+1} = lw;
    nnets{k}.b{j+1}  = lb;
  end
  k = k + 1;
end
