import eam
import numpy as np

def ECuH2(R,conf):
    cell = np.array([[15.3455999999999992],[21.7020000000000017],[100.0000000000000000]])
    N_im = np.shape(R)[0]
    conf = np.reshape(conf,[654,1])
    E = np.zeros([N_im,1])
    G = np.zeros([N_im,6])
    for i in range(N_im):
        conf[648:651,0] = R[i,0:3]
        conf[651:654,0] = R[i,3:6]
        Fi, Ei = eam.force_eam(cell,conf)
        E[i,0] = Ei
        G[i,0:6] = -Fi[648:654]
    return E, G

def conf_CuH2():
    conf = np.array([0.6394,0.9045,6.9753,
    3.1970,    0.9045,    6.9753,
    5.7546,    0.9045,    6.9753,
    8.3122,    0.9045,    6.9753,
   10.8698,    0.9045,    6.9753,
   13.4274,    0.9045,    6.9753,
    0.6394,    4.5215,    6.9754,
    3.1970,    4.5215,    6.9754,
    5.7546,    4.5215,    6.9754,
    8.3122,    4.5215,    6.9754,
   10.8698,    4.5215,    6.9754,
   13.4274,    4.5215,    6.9754,
    0.6394,    8.1385,    6.9754,
    3.1970,    8.1385,    6.9754,
   13.4274,    8.1385,    6.9754,
    0.6394,   11.7555,    6.9754,
    3.1970,   11.7555,    6.9754,
   13.4274,   11.7555,    6.9754,
    0.6394,   15.3725,    6.9754,
    3.1970,   15.3725,    6.9754,
    5.7546,   15.3725,    6.9754,
    8.3122,   15.3725,    6.9754,
   10.8698,   15.3725,    6.9754,
   13.4274,   15.3725,    6.9754,
    0.6394,   18.9895,    6.9754,
    3.1970,   18.9895,    6.9754,
    5.7546,   18.9895,    6.9754,
    8.3122,   18.9895,    6.9754,
   10.8698,   18.9895,    6.9754,
   13.4274,   18.9895,    6.9754,
    1.9182,    2.7130,    5.7487,
    4.4758,    2.7130,    5.7487,
    7.0334,    2.7130,    5.7487,
    9.5910,    2.7130,    5.7487,
   12.1486,    2.7130,    5.7487,
   14.7062,    2.7130,    5.7487,
    1.9182,    6.3300,    5.7487,
    4.4758,    6.3300,    5.7487,
    7.0334,    6.3300,    5.7487,
    9.5910,    6.3300,    5.7487,
   12.1486,    6.3300,    5.7487,
   14.7062,    6.3300,    5.7487,
    1.9182,    9.9470,    5.7487,
    4.4758,    9.9470,    5.7487,
   12.1486,    9.9470,    5.7487,
   14.7062,    9.9470,    5.7487,
    1.9182,   13.5640,    5.7487,
    4.4758,   13.5640,    5.7487,
    7.0334,   13.5640,    5.7487,
    9.5910,   13.5640,    5.7487,
   12.1486,   13.5640,    5.7487,
   14.7062,   13.5640,    5.7487,
    1.9182,   17.1810,    5.7487,
    4.4758,   17.1810,    5.7487,
    7.0334,   17.1810,    5.7487,
    9.5910,   17.1810,    5.7487,
   12.1486,   17.1810,    5.7487,
   14.7062,   17.1810,    5.7487,
    1.9182,   20.7980,    5.7487,
    4.4758,   20.7980,    5.7487,
    7.0334,   20.7980,    5.7487,
    9.5910,   20.7980,    5.7487,
   12.1486,   20.7980,    5.7487,
   14.7062,   20.7980,    5.7487,
    0.6394,    0.9045,    4.4612,
    3.1970,    0.9045,    4.4612,
    5.7546,    0.9045,    4.4612,
    8.3122,    0.9045,    4.4612,
   10.8698,    0.9045,    4.4612,
   13.4274,    0.9045,    4.4612,
    0.6394,    4.5215,    4.4612,
    3.1970,    4.5215,    4.4612,
    5.7546,    4.5215,    4.4612,
    8.3122,    4.5215,    4.4612,
   10.8698,    4.5215,    4.4612,
   13.4274,    4.5215,    4.4612,
    0.6394,    8.1385,    4.4612,
    3.1970,    8.1385,    4.4612,
    5.7546,    8.1385,    4.4612,
    8.3122,    8.1385,    4.4612,
   10.8698,    8.1385,    4.4612,
   13.4274,    8.1385,    4.4612,
    0.6394,   11.7555,    4.4612,
    3.1970,   11.7555,    4.4612,
    5.7546,   11.7555,    4.4612,
    8.3122,   11.7555,    4.4612,
   10.8698,   11.7555,    4.4612,
   13.4274,   11.7555,    4.4612,
    0.6394,   15.3725,    4.4612,
    3.1970,   15.3725,    4.4612,
    5.7546,   15.3725,    4.4612,
    8.3122,   15.3725,    4.4612,
   10.8698,   15.3725,    4.4612,
   13.4274,   15.3725,    4.4612,
    0.6394,   18.9895,    4.4612,
    3.1970,   18.9895,    4.4612,
    5.7546,   18.9895,    4.4612,
    8.3122,   18.9895,    4.4612,
   10.8698,   18.9895,    4.4612,
   13.4274,   18.9895,    4.4612,
    1.9182,    2.7130,    3.1970,
    4.4758,    2.7130,    3.1970,
    7.0334,    2.7130,    3.1970,
    9.5910,    2.7130,    3.1970,
   12.1486,    2.7130,    3.1970,
   14.7062,    2.7130,    3.1970,
    1.9182,    6.3300,    3.1970,
    4.4758,    6.3300,    3.1970,
    7.0334,    6.3300,    3.1970,
    9.5910,    6.3300,    3.1970,
   12.1486,    6.3300,    3.1970,
   14.7062,    6.3300,    3.1970,
    1.9182,    9.9470,    3.1970,
    4.4758,    9.9470,    3.1970,
    7.0334,    9.9470,    3.1970,
    9.5910,    9.9470,    3.1970,
   12.1486,    9.9470,    3.1970,
   14.7062,    9.9470,    3.1970,
    1.9182,   13.5640,    3.1970,
    4.4758,   13.5640,    3.1970,
    7.0334,   13.5640,    3.1970,
    9.5910,   13.5640,    3.1970,
   12.1486,   13.5640,    3.1970,
   14.7062,   13.5640,    3.1970,
    1.9182,   17.1810,    3.1970,
    4.4758,   17.1810,    3.1970,
    7.0334,   17.1810,    3.1970,
    9.5910,   17.1810,    3.1970,
   12.1486,   17.1810,    3.1970,
   14.7062,   17.1810,    3.1970,
    1.9182,   20.7980,    3.1970,
    4.4758,   20.7980,    3.1970,
    7.0334,   20.7980,    3.1970,
    9.5910,   20.7980,    3.1970,
   12.1486,   20.7980,    3.1970,
   14.7062,   20.7980,    3.1970,
    0.6394,    0.9045,    1.9182,
    3.1970,    0.9045,    1.9182,
    5.7546,    0.9045,    1.9182,
    8.3122,    0.9045,    1.9182,
   10.8698,    0.9045,    1.9182,
   13.4274,    0.9045,    1.9182,
    0.6394,    4.5215,    1.9182,
    3.1970,    4.5215,    1.9182,
    5.7546,    4.5215,    1.9182,
    8.3122,    4.5215,    1.9182,
   10.8698,    4.5215,    1.9182,
   13.4274,    4.5215,    1.9182,
    0.6394,    8.1385,    1.9182,
    3.1970,    8.1385,    1.9182,
    5.7546,    8.1385,    1.9182,
    8.3122,    8.1385,    1.9182,
   10.8698,    8.1385,    1.9182,
   13.4274,    8.1385,    1.9182,
    0.6394,   11.7555,    1.9182,
    3.1970,   11.7555,    1.9182,
    5.7546,   11.7555,    1.9182,
    8.3122,   11.7555,    1.9182,
   10.8698,   11.7555,    1.9182,
   13.4274,   11.7555,    1.9182,
    0.6394,   15.3725,    1.9182,
    3.1970,   15.3725,    1.9182,
    5.7546,   15.3725,    1.9182,
    8.3122,   15.3725,    1.9182,
   10.8698,   15.3725,    1.9182,
   13.4274,   15.3725,    1.9182,
    0.6394,   18.9895,    1.9182,
    3.1970,   18.9895,    1.9182,
    5.7546,   18.9895,    1.9182,
    8.3122,   18.9895,    1.9182,
   10.8698,   18.9895,    1.9182,
   13.4274,   18.9895,    1.9182,
    1.9182,    2.7130,    0.6394,
    4.4758,    2.7130,    0.6394,
    7.0334,    2.7130,    0.6394,
    9.5910,    2.7130,    0.6394,
   12.1486,    2.7130,    0.6394,
   14.7062,    2.7130,    0.6394,
    1.9182,    6.3300,    0.6394,
    4.4758,    6.3300,    0.6394,
    7.0334,    6.3300,    0.6394,
    9.5910,    6.3300,    0.6394,
   12.1486,    6.3300,    0.6394,
   14.7062,    6.3300,    0.6394,
    1.9182,    9.9470,    0.6394,
    4.4758,    9.9470,    0.6394,
    7.0334,    9.9470,    0.6394,
    9.5910,    9.9470,    0.6394,
   12.1486,    9.9470,    0.6394,
   14.7062,    9.9470,    0.6394,
    1.9182,   13.5640,    0.6394,
    4.4758,   13.5640,    0.6394,
    7.0334,   13.5640,    0.6394,
    9.5910,   13.5640,    0.6394,
   12.1486,   13.5640,    0.6394,
   14.7062,   13.5640,    0.6394,
    1.9182,   17.1810,    0.6394,
    4.4758,   17.1810,    0.6394,
    7.0334,   17.1810,    0.6394,
    9.5910,   17.1810,    0.6394,
   12.1486,   17.1810,    0.6394,
   14.7062,   17.1810,    0.6394,
    1.9182,   20.7980,    0.6394,
    4.4758,   20.7980,    0.6394,
    7.0334,   20.7980,    0.6394,
    9.5910,   20.7980,    0.6394,
   12.1486,   20.7980,    0.6394,
   14.7062,   20.7980,    0.6394,
    5.7546,    8.1385,    6.9754,
    8.3122,    8.1385,    6.9754,
   10.8698,    8.1385,    6.9754,
    5.7546,   11.7555,    6.9754,
    8.3122,   11.7555,    6.9754,
   10.8698,   11.7555,    6.9754,
    7.0334,    9.9470,    5.7487,
    9.5910,    9.9470,    5.7487,
    8.6822,    9.9470,   11.7330,
    7.9422,    9.9470,   11.7330])
    conf = np.reshape(conf,[218,3])
    return conf

