##### demo_muller_brown_dimer.m
##### Copyright: Olli-Pekka Koistinen, Aalto University, 7.7.2020
#####
##### This script shows how to use 'dimer.py' in a Muller-Brown example.

import numpy as np
import matplotlib.pyplot as plt
import utils_dimer
import dimer
import muller_brown

pot_general = muller_brown.muller_brown # define the potential energy function

R_init = np.array([[-0.6978,0.5446]]) # define the initial middle point of the dimer
D = R_init.shape[1]
orient_init = np.array([[-0.0830,0.9965]]) # define the initial orientation of the dimer (unit vector along the direction of the dimer)
dimer_sep = 0.01 # define the dimer separation (distance from the middle point of the dimer to the two images)
method_rot = utils_dimer.rot_iter_lbfgsext # use the L-BFGS method for rotations (with extrapolation of G1)
method_trans = utils_dimer.trans_iter_lbfgs # use the L-BFGS method for translations
param_trans = np.array([[0.1, 0.1]]) # define a step length for convex regions and maximum step length
T_dimer = 0.01 # define the convergence threshold for the maximum component of the force acting on the middle point of the dimer
T_anglerot = 0.0873 # define the convergence threshold for the rotation angle
num_iter_rot = np.min((D,10)) # define the maximum number of rotation iterations per translation
num_iter = 200 # define the maximum number of iterations

# Call the dimer function
R, orient, E_R, G_R, R_all, E_all, G_all, E_R_acc, maxF_R_acc, obs_total, figs = \
dimer.dimer(pot_general=pot_general,R_init=R_init,orient_init=orient_init,method_rot=method_rot, \
method_trans=method_trans,param_trans=param_trans,dimer_sep=dimer_sep,T_dimer=T_dimer, \
T_anglerot=T_anglerot,num_iter_rot=num_iter_rot,num_iter=num_iter)

fig = plt.figure()

sub1 = fig.add_subplot(121)
sub1.set_title('Maximum component of force at the middle point')
sub1.plot(range(maxF_R_acc.shape[0]),maxF_R_acc)
sub1.set_xlabel('iteration')

sub2 = fig.add_subplot(122)
sub2.set_title('Energy at the middle point')
sub2.plot(range(E_R_acc.shape[0]),E_R_acc)
sub2.set_xlabel('iteration')

plt.show()