##### demo_muller_brown_NEB2.py
##### Copyright: Olli-Pekka Koistinen, Aalto University, 9.7.2020
#####
##### This script shows how to use 'NEB2.py' in a Muller-Brown example.

import numpy as np
import matplotlib.pyplot as plt
import utils
import NEB2
import muller_brown

pot_general = muller_brown.muller_brown # define the potential energy function

min1 = np.array([[-0.5582,1.4417]]) # define the first minimum point
min2 = np.array([[0.6235,0.0280]]) # define the second minimum point
N_im = 10 # define the number of images on the path
R_init = utils.initialize_path_linear(min1,min2,N_im) # define the initial path
method_step = utils.step_QMVelocityVerlet # define the step method (e.g., "qmVV" or "simple")
param_step = 0.1 # define parameters for the step method (time step in case of qmVV)
method_force = utils.force_NEB2 # use regular NEB force
param_force = 1.0 # define parallel spring constant
#method_force = utils.force_sNEB2 # use sNEB force
#param_force = np.array([[1.0,1.0]]) # define parallel and perpendicular spring constants
T_MEP = 0.001 # define the convergence threshold for the maximum component of the force perpendicular to the path tangent
T_CI = 0.001 # define the additional convergence threshold for the maximum force component at the climbing image
T_CIon = 0.01 # define the preliminary convergence threshold after which the climbing image mode is turned on (0 if not used at all)
num_iter = 10000 # define the maximum number of iterations
quatern = 0 # no quaternion trick used
visualize = 1 # set visualization option on (requires large amount of extra evaluations so not to be used in real applications)

# Call the sNEB function:
R, E_R, G_R, i_CI, E_R_acc, maxG_R_perp_acc, maxG_CI_acc, figs = NEB2.NEB2(pot_general,R_init,method_step,param_step,method_force,param_force,T_MEP,T_CI,T_CIon,num_iter,quatern,visualize)

fig = plt.figure()

sub1 = fig.add_subplot(121)
sub1.set_title('Maximum component of perpendicular gradient on one image')
sub1.plot(range(maxG_R_perp_acc.shape[1]),np.max(maxG_R_perp_acc,0),label='Max')
sub1.plot(range(maxG_R_perp_acc.shape[1]),np.min(maxG_R_perp_acc,0),label='Min')
sub1.plot(range(maxG_CI_acc.shape[0]),maxG_CI_acc,label='CI')
sub1.set_xlabel('iteration')
sub1.legend()

sub2 = fig.add_subplot(122)
sub2.set_title('Maximum energy over the images')
sub2.plot(range(E_R_acc.shape[1]),np.max(E_R_acc,0))
sub2.set_xlabel('iteration')

plt.show()
