%%%%% step_simple.m
%%%%% Copyright: Olli-Pekka Koistinen, Aalto University, 1.8.2018
%%%%%
%%%%% This is function moves the path simply one step along the NEB force.
%%%%%
%%%%% Input:
%%%%%   R           coordinates for the images on the current path (N_im x D)
%%%%%   F_R         NEB force on the intermediate images on the current path
%%%%%   param_step  step size coefficient K_step (scalar)
%%%%%   F_R_old     NEB force on the intermediate images on the previous path (irrelevant for this method)
%%%%%   V_old       velocity of the intermediate images (irrelevant for this method)
%%%%%   zeroV       indicator if zero velocity used (irrelevant for this method)
%%%%%
%%%%% Output:
%%%%%   R_new       coordinates for the images on the moved path
%%%%%   V           velocity of the intermediate images (irrelevant for this method -> zeros)

function [R_new,V] = step_simple(R,F_R,param_step,F_R_old,V_old,zeroV)
    K_step = param_step;
    [N_im,D] = size(R);
    R_new = R;
    R_new(2:(N_im-1),:) = R(2:(N_im-1),:) + K_step*F_R; % move the intermediate images
    V = zeros(N_im-2,D);
end
