%%%%% potential_gp.m
%%%%% Copyright: Olli-Pekka Koistinen, Aalto University, 8.1.2019
%%%%%
%%%%% This auxiliary function calculates energy and gradient for given images 'R'
%%%%% according to a GP model specified by the remaining input variables.
%%%%%
%%%%% Input:
%%%%%   R       coordinates of the images (N_im x D)
%%%%%   gp      GPstuff structure
%%%%%   R_all2  coordinates of training data points ((D+1)*N_im x (D+1))
%%%%%             (includes an additional index to specify derivative observations)
%%%%%   a       precalculated auxiliary variable
%%%%%
%%%%% Output:
%%%%%   E_R     energy for the images (N_im x 1)
%%%%%   G_R     gradient for the images (N_im x D)

function [E_R,G_R] = potential_gp(R,gp,R_all2,a)
    [N_im,D] = size(R);
    KK = gp_cov(gp,R_all2,[repmat(R,D+1,1),reshape(repmat(0:D,N_im,1),[],1)]);
    EG_R = KK'*a;
    E_R = EG_R(1:N_im,1);
    G_R = reshape(EG_R((N_im+1):end,1),N_im,D);
end