%%%%% initialize_path_linear.m
%%%%% Copyright: Olli-Pekka Koistinen, Aalto University, 13.7.2017
%%%%%
%%%%% This function initializes a linear path 'R_line' of 'num_im' images
%%%%% between two minimum points 'min1' and 'min2'.
%%%%%
%%%%% Input:
%%%%%   min1    coordinates for minimum point 1
%%%%%   min2    coordinates for minimum point 2
%%%%%   N_im  number of images on the path
%%%%%
%%%%% Output:
%%%%%   R_line  coordinates for the images on the linear path

function R_line = initialize_path_linear(min1,min2,N_im)
    D = size(min1,2); % dimension of the space
    R_line = zeros(N_im,D); % coordinates of the images
    R_line(1,:) = min1; % set first image to minimum point 1
    R_line(end,:) = min2; % set last image to minimum point 2
    interval = (min2-min1)/(N_im-1); % the initial interval between the images
    for i = 2:(N_im-1)
        R_line(i,:) = min1 + interval*(i-1); % set the intermediate images on a straight line
    end
end
