%%%%% get_hessian_points.m
%%%%% Copyright: Olli-Pekka Koistinen, Aalto University, 13.7.2017
%%%%%
%%%%% This function defines the "virtual Hessian" points, i.e., additional
%%%%% observation coordinates around both minimum points. The points are
%%%%% located at a distance 'epsilon' from the minimum point towards each
%%%%% coordinate axis.
%%%%%
%%%%% Input:   R        coordinates of the images on the path
%%%%%          epsilon  distance from the minimum points
%%%%% Output:  Rh       coordinates of the "virtual Hessian" points

function Rh = get_hessian_points(R,epsilon)
    N_im = size(R,1);
    D = size(R,2);
    Rh = zeros(2*D,D);
    for d = 1:D
        Rh(d,:) = R(1,:);
        Rh(D+d,:) = R(end,:);
        Rh(d,d) = Rh(d,d) + epsilon;
        Rh(D+d,d) = Rh(D+d,d) + epsilon;
    end
end