%%%%% force_rot.m
%%%%% Copyright: Olli-Pekka Koistinen, Aalto University, 31.12.2018
%%%%%
%%%%% This is an auxiliary function for the dimer method ('dimer.m').
%%%%%
%%%%% Input:
%%%%%   G01          gradient vectors at the middle point and image 1 of the dimer (2 x D)
%%%%%   orient       unit vector along the direction of the dimer (1 x D)
%%%%%   dimer_sep    dimer separation (distance from the middle point of the dimer to the two images)
%%%%%   
%%%%% Output:
%%%%%   F_rot        rotational force acting on image 1 of the dimer (1 x D)

function F_rot = force_rot(G01,orient,dimer_sep)
    F1 = -G01(2,:);
    F2 = -2*G01(1,:)+G01(2,:);
    F1_rot = F1-(F1*orient')*orient;
    F2_rot = F2-(F2*orient')*orient;
    F_rot = (F1_rot - F2_rot)/dimer_sep;
end
