%%%%% demo_muller_brown_GP_dimer.m
%%%%% Copyright: Olli-Pekka Koistinen, Aalto University, 9.7.2020
%%%%%
%%%%% This script shows how to use 'GP_dimer.m' in a Muller-Brown example.

pot_general = @(R) muller_brown(R); % define the potential energy function

R_all_init = []; % no initial data points
E_all_init = []; % no initial data
G_all_init = []; % no initial data
R_init = [-0.6978,0.5446]; % define the initial middle point of the dimer
E_init = []; % initial middle point not observed
G_init = []; % initial middle point not observed
orient_init = [-0.0830,0.9965]; % define the initial orientation of the dimer (unit vector along the direction of the dimer)
D = size(R_init,2);

dimer_sep = 0.01; % define the dimer separation (distance from the middle point of the dimer to the two images)
method_rot = @rot_iter_cg; % use the conjugate gradient method for rotations
method_trans = @trans_iter_cg; % use the conjugate gradient method for translations
param_trans = [0.1, 0.1]; % define a step length for convex regions and maximum step length

% 'eval_image1' indicates if image 1 of the dimer is evaluted (1) or not (0)
% after each relaxation phase in addition to the middle point of the dimer
eval_image1 = 0;

% 'T_dimer' defines the final convergence threshold for 'maxF_R', which is
% the maximum component of the force acting on the middle point of the dimer (i.e., the
% algorithm is stopped when all components of the accurate force are below 'T_dimer').
T_dimer = 0.01;

% 'initrot_nogp' indicates if the initial rotations are performed without GP (1) or with GP (0).
initrot_nogp = 0;

% 'T_anglerot_init' defines a convergence threshold for the rotation angle
% in the initial rotations performed in the beginning of the algorithm
% (the dimer is not rotated when the estimated rotation angle is less than this).
T_anglerot_init = 0.0873;

% 'num_iter_initrot' defines the maximum number of initial rotations (0 if initial rotations skipped).
num_iter_initrot = D;

% 'inittrans_nogp' is an indicator if an initial test translation step is taken without GP (1)
% or if GP is used right after initial rotations (0).
inittrans_nogp = 0;

% 'T_anglerot_gp' defines a convergence threshold for the rotation angle
% during a relaxation phase (the dimer is not rotated when the estimated
% rotation angle is less than this).
T_anglerot_gp = 0.01;

% 'num_iter_rot_gp' defines a maximum number of rotation iterations per
% translation during a relaxation phase.
num_iter_rot_gp = 10;

% If 'divisor_T_dimer_gp' is set to zero, the default convergence threshold
% for each relaxation phase for the approximated 'maxF_R' on the
% approximated energy surface is 1/10 of the 'T_dimer'. To save inner
% iterations during the first relaxation phases, one can set a positive
% value for 'divisor_T_dimer_gp', so that the GP convergence threshold will
% be 1/'divisor_T_dimer_gp' of the smallest accurate 'maxF_R' obtained so
% far, but not less than 1/10 of the 'T_dimer'. If the approximation error
% is assumed to not decrease more than that during one outer iteration,
% there is no need for more accurate relaxation on an approximated surface.
divisor_T_dimer_gp = 10;

% 'disp_max' defines the maximum displacement of the middle point of the
% dimer from the nearest observed data point. Thus, the last inner step is
% rejected and the relaxation phase stopped, if the distance to the nearest
% observed data point is larger than 'disp_max'.
disp_max = 0.5;

% 'num_bigiter_initloc' defines the number of outer iterations started from the initial location 'R_init'.
% After that, each relaxation phase is started from the latest converged dimer.
% Starting each round from the initial location may improve stability (and decrease outer iterations),
% but starting from the latest dimer may decrease the number of inner iterations during the relaxation phases.
num_bigiter_initloc = inf;

% 'num_bigiter_initparam' defines the number of outer iterations where the hyperparameter
% optimization is started from values initialized based on the range of current data.
% After that, the optimization is started from the values of the previous round.
num_bigiter_initparam = inf;

num_bigiter = 300; % define the maximum number of outer iterations (new sets of observations)
num_iter = 10000; % define the maximum number of inner iterations (steps during a relaxation phase)

% 'islarge_num_iter' indicates if 'num_iter' is assumed to be much larger than required
% for dimer convergence on accurate energy surface. If not (0), the next relaxation phase is
% continued from the current dimer in case 'num_iter' is reached.
islarge_num_iter = 1;

load_file = []; % start normally from beginning
save_file = []; % no saves after each outer iteration

% Call the GP-dimer algorithm
[R,orient,E_R,G_R,gp,R_all,E_all,G_all,obs_at,E_R_acc,E_R_gp,maxF_R_acc,maxF_R_gp,param_gp_initrot,param_gp,obs_initrot,obs_total,num_esmax,num_es1,num_es2] = ...
             GP_dimer(pot_general,R_all_init,E_all_init,G_all_init,R_init,E_init,G_init,orient_init,dimer_sep,method_rot,method_trans, ...
             param_trans,eval_image1,T_dimer,initrot_nogp,T_anglerot_init,num_iter_initrot,inittrans_nogp,T_anglerot_gp,num_iter_rot_gp,divisor_T_dimer_gp, ...
             disp_max,num_bigiter_initloc,num_bigiter_initparam,num_bigiter,num_iter,islarge_num_iter,load_file,save_file);

%{
% Plot the behaviour
figure
subplot(2,1,1)
title('Maximum component of force on the middle point (GP approximation)')
xlabel('iteration')
hold
plot(0:(size(maxF_R_gp,2)-1),maxF_R_gp)
plot(obs_at,maxF_R_acc,'o')
subplot(2,1,2)
title('Energy at the middle point (GP approximation)')
xlabel('iteration')
hold
plot(0:(size(E_R_gp,2)-1),E_R_gp)  
plot(obs_at,E_R_acc,'o')
%}
