function [Ei,G] = Etip4p(R,conf)

%'External' tip4p routine - simply to convert it to GP-sNEB compatible
% format and adjust units, as internal units of compiled tip4p are
% atomic.

%input  R: coordinates [Nx3] (note: Unit should be angstrom, it is converted
%to atomic units within this routine)
%output E: energy [1x1] (unit is eV)
%output F: forces [Nx3] (unit is eV/angstr)


%constants needed for unit conversion
angstrtoau = 1.8897259885789;
Eautoev=27.2113825435;
Fautoev = 51.422086190832;

%define cell dimension (if the system is changed, these numbers will change)
box = [13.52118,15.61292,25.059136]*angstrtoau;


%Run the actual computation by calling the compiled fortran function
% If running for the first time; write in cmd line ">> mex tip4p.F90"
N_T = size(conf,1); 
num_im = size(R,1); 
dim = size(R,2); 
E = zeros(num_im,1);
G = zeros(num_im,dim);
for i = 1:num_im
    conf = update_conf(R(i,:),conf);
    x = reshape(conf(:,1:3),N_T,3);
    [F,Ei,vir] = tip4p(box,x*angstrtoau);
   % Gi = reshape(-F,3,N_T)';
    Gi = F(conf(:,4)==0,:);
    Gi = reshape(Gi',1,size(Gi,1)*3);
    G(i,:) = Gi;
end



% Convert energy and forces to eV and eV/angstr, respectively.
Ei=Ei*Eautoev;
G=G*Fautoev;
end

