%%%%% relax_initial_conf_muller_brown.m
%%%%% Copyright: Olli-Pekka Koistinen, Aalto University, 13.7.2017
%%%%%
%%%%% This function finds accurate local minimum point for the 2D example.
%%%%%
%%%%% Input:   conf_old    a point nearby the accurate minimum point
%%%%% Output:  conf_relax  accurate minimum point

function conf_relax = relax_initial_conf_muller_brown(conf_old)

    conf = conf_old;
    pots = [];
    K = 0.001;
    for i = 1:10000
        [E,G] = muller_brown(conf);
        conf = conf-K*G;
        pots = [pots;E];
    end
    conf_relax = conf;
    plot(pots);
    
end