%%%%% relax_initial_conf.m
%%%%% Copyright: Olli-Pekka Koistinen, Aalto University, 13.7.2017
%%%%%
%%%%% This function finds an accurate local minimum point for the Morse potential.
%%%%%
%%%%% Input:   conf_old    a configuration nearby the accurate minimum energy configuration
%%%%%                        (includes the coordinates of all atoms and the information if they are freezed or not)
%%%%% Output:  conf_relax  the accurate minimum energy configuration
%%%%%                        (includes the coordinates of all atoms and the information if they are freezed or not)
%%%%%          pots        the potential energy values during the relaxation

function [conf_relax,pots] = relax_initial_conf(conf_old)

    conf = conf_old;
    pots = [];
    K = 0.001;
    for i = 1:4000
        [pot,grad] = morsepotential(conf2vec(conf),conf);
        conf = update_conf(conf2vec(conf)-K*grad,conf);
        pots = [pots;pot];
    end
    conf_relax = conf;
    figure();
    plot(pots);
    
end