%%%%% morsepotential.m
%%%%% Copyright: Olli-Pekka Koistinen, Aalto University, 13.7.2017
%%%%%
%%%%% This function gives the Morse potential energy and its gradient for
%%%%% the images on the path R.
%%%%%
%%%%% Input:   R     the coordinates of the images on the path in the form used by GP-MEP
%%%%%                  (each row (image) includes only the coordinates of the unfreezed atoms)
%%%%%          conf  the configuration of the whole atomic system
%%%%%                  (includes the coordinates of all atoms and the information if they are freezed or not)
%%%%%                  (the coordinates of the unfreezed atoms are ignored, and thus can be anything)
%%%%% Output:  E     the energies at the images on the path
%%%%%          G     the gradients at the images on the path

function [E,G] = morsepotential(R,conf)
    
    N_T = size(conf,1);
    num_im = size(R,1);
    dim = size(R,2);
    E = zeros(num_im,1);
    G = zeros(num_im,dim);
    for i = 1:num_im
        conf = update_conf(R(i,:),conf);
        x = reshape(conf(:,1:3)',N_T*3,1);
        boxx = [1.9209e+01, 0, 0, 0, 1.9012e+01, 0, 0, 0, 3.0000e+01];
        [Ei, ~, Gi, ~] = calllib('libmorse', 'force', N_T, x, x, boxx);
        E(i,1) = Ei;
        Gi = reshape(-Gi,3,N_T)';
        Gi = Gi(conf(:,4)==0,:);
        Gi = reshape(Gi',1,size(Gi,1)*3);
        G(i,:) = Gi;
    end
    
end