%%%%% morse_visualize_R.m
%%%%% Copyright: Olli-Pekka Koistinen, Aalto University, 13.7.2017
%%%%%
%%%%% This script visualizes the images on the path by transforming the
%%%%% configurations into txt-files that can be viewed with OVITO
%%%%% visualization tool.

num_atoms = size(conf,1);
for im = 1:num_im
    conf_new = update_conf(R(im,:),conf);
    fileID = fopen(sprintf('%d.txt',im-1),'w');
    fprintf(fileID,'ITEM: TIMESTEP\n');
    fprintf(fileID,'%d\n',im-1);
    fprintf(fileID,'ITEM: NUMBER OF ATOMS\n');
    fprintf(fileID,'%d\n',num_atoms);
    fprintf(fileID,'ITEM: BOX BOUNDS ff ff ff\n');
    fprintf(fileID,'0 19.209\n');
    fprintf(fileID,'0 19.012\n');
    fprintf(fileID,'0 30.000\n');
    fprintf(fileID,'ITEM: ATOMS id type x y z\n');
    for i = 1:num_atoms
        fprintf(fileID,'%d %d %f %f %f\n',i,conf_new(i,4),conf_new(i,1),conf_new(i,2),conf_new(i,3));
    end
    fclose(fileID);
end