function [R] = readxyz(fname)
%%
% Reads the coordinates from a typical .xyz file
% INPUT: fname - filename as a string
%
% OUTPUT: R - atomic coordinates as a Nx3 array (N = no. of atoms)
%
%%
fid = fopen(fname,'r');
F=textscan(fid,'%s %f %f %f','Headerlines',2);
R=cell2mat(F(:,2:4));
fclose(fid);
end

