%%%%% conf2vec.m
%%%%% Copyright: Olli-Pekka Koistinen, Aalto University, 13.7.2017
%%%%%
%%%%% This function gives the coordinates of the unfreezed atoms in an
%%%%% atomic configuration as one vector.
%%%%%
%%%%% Input:   conf  the configuration of the whole atomic system
%%%%%                  (includes the coordinates of all atoms and the information if they are freezed or not)
%%%%% Output:  vec   the coordinates of the unfreezed atoms as one vector

function vec = conf2vec(conf)

    vec = conf(conf(:,4)==0,1:3);
    dim = size(vec,1)*3;
    vec = reshape(vec',1,dim);

end