function [E,G] = EvalLJ(R, conf)

% Made from the structure of Etip4p
% simply the library call was replaced by Matlab call to routine LJSP.

N_T = size(conf,1);
num_im = size(R,1);
dim = size(R,2);
E = zeros(num_im, 1);
G = zeros(num_im, dim);

for i = 1:num_im
    conf = update_conf(R(i,:),conf);
    x = reshape(conf(:,1:3),N_T,3);
    [Gi,Ei] = LennardJonesSP(x);
    E(i,1) = Ei;
    Gi = -Gi(conf(:,4)==0,:);
    Gi = reshape(Gi',1,size(Gi,1)*3);
    G(i,:) = Gi;
end
end

