function [] = wrORCAinput(pathtofile, symb, R)


[natoms, ~] = size(R);

%charge and multiplicity (system specific)
charge = 0;
multiplicity = 1;

% Function to write input file  for ORCA on disc
% (hard-coded to the PM3 semi-empirical method)
fid=fopen(pathtofile, 'w');

fprintf(fid, '!PM3 ENGRAD\n');
fprintf(fid, '*xyz %i %i\n', charge, multiplicity);
for i = 1:natoms
    fprintf(fid, '%s %12.8f %12.8f %12.8f\n', symb(i), R(i,1), R(i,2), R(i,3));
end
fprintf(fid, '*\n');
fclose(fid);

end