function [gradient, energy] = readORCAoutput(outputfile, natoms)

%pre-allocate gradient rray
gradient = zeros(natoms,3);
energy = 0.0;

%read outputfile
fid=fopen(outputfile, 'r');
tline = fgetl(fid);
start_reading = 0;
calculation_finish = 0;
ind = 1;
while ischar(tline)
    tline = fgetl(fid);
    if isa(tline,'char')
        
        %disp(tline)
        if contains(tline, 'Norm of the cartesian gradient')
            start_reading = 0;
            ind = 1;
        end
        
        if start_reading == 1
            % only read the 'required' part of the outputfile
            %tmp=%regexp(tline,'\d.*','Match');
            tmp=regexp(tline,'[+-]?\d+\.?\d*', 'match');
            if tmp ~= ""
                gradient(ind,1) = str2double(tmp(2));
                gradient(ind,2) = str2double(tmp(3));
                gradient(ind,3) = str2double(tmp(4));
                ind = ind+1;
            end
            
            %if ~isempty(tmp)
            %    strforce = strsplit(tmp{1});
            %    gradient(ind, 1) = str2double(strforce{4});
            %    gradient(ind, 2) = str2double(strforce{5});
            %    gradient(ind, 3) = str2double(strforce{6});
            %    ind = ind+1;
            %end
        end
        
        if strcmp(tline, 'The cartesian gradient:')
            start_reading = 1;
        end
        
        
        if contains(tline, 'FINAL SINGLE POINT ENERGY')
            energy = regexp(tline,'[+-]?\d+\.?\d*', 'match');%'\d.*','Match');
      
        end
        
        if contains(tline, '****ORCA TERMINATED NORMALLY****')
            calculation_finish = 1;
        end
        
    end
end
fclose(fid);

if calculation_finish == 0
    error("orca did not terminate correctly - please inspect the orca files")
end

energy = str2double(energy);
%convert to energy to ev and forces to ev/angstr
energy = energy*27.2114;
gradient = gradient*(27.2114/0.5292);
end