%%%%% 
%%%%% Copyright: Olli-Pekka Koistinen, Aalto University, 1.8.2018
%%%%%
%%%%% 

clear all
addpath(genpath('/home/via9/SOFTWARE/GPR_NEB_MATLAB/atomic_GP-sNEB_2018_08_01/GPR_NEB_SCRIPTS/'))
addpath(genpath('/home/via9/SOFTWARE/GPR_NEB_MATLAB/atomic_GP-sNEB_2018_08_01/additional_scripts_from_villi/'))
addpath(genpath('/home/via9/SOFTWARE/GPR_NEB_MATLAB/atomic_GP-sNEB_2018_08_01/data_ORCA/'))
addpath(genpath('/home/via9/SOFTWARE/GPR_NEB_MATLAB/gpstuff-develop/'))

[conf1,symb] = readxyz('reactI.xyz'); 
[conf2,symb] = readxyz('prodI.xyz');
constr = zeros(length(conf1),1);

conf1= [conf1 constr];
conf2= [conf2 constr];
conf = conf1; %the full system


pot_general = @(R) EORCA(R,conf); 
min1 = conf2vec(conf1); % minimum point 1
min2 = conf2vec(conf2); % minimum point 2

num_im = 8; % define the number of images on the path
R_init = initialize_path_linear(min1,min2,num_im); % define the initial path
method_step = @(R,F_R,param_step,F_R_old,V_old,iter) step_QMVelocityVerlet(R,F_R,param_step,F_R_old,V_old,iter); % use quick-min Velocity Verlet to define the steps path relaxation
param_step = 0.01; % define the time step for the quick-min Velocity Verlet algorithm
k_par = 1; % define the parallel spring constant
k_perp = 1; % define the perpendicular spring constant
maxnormF_conv = 0.1; % define the convergence limit for the maximum norm of the force
normFCI_conv = 0.01; % define the additional convergence requirement for the climbing image
maxnormF_CIon = inf; % define the convergence limit after which the climbing image option is turned on (0 if not used at all)
num_iter = 10000; % define the maximum number of iterations

% Call the NEB function
fprintf('Starting NEB\n')
  [R, E_R, G_R, i_CI, E_R_acc, normF_R_acc, normFCI_acc, no_of_iter] = NEB_extended(pot_general, conf, R_init, method_step, param_step, k_par,  maxnormF_conv, normFCI_conv, maxnormF_CIon, num_iter);
fprintf('end NEB\n')
save('results.mat')
fprintf('done\n')
