%%%%% update_conf.m
%%%%% Copyright: Olli-Pekka Koistinen, Aalto University, 13.7.2017
%%%%%
%%%%% This function updates an atomic configuration with new coordinates
%%%%% for the unfreezed atoms.
%%%%%
%%%%% Input:   vec       the new coordinates of the unfreezed atoms as one vector
%%%%%          conf_old  the old configuration of the whole atomic system
%%%%%                      (includes the coordinates of all atoms and the information if they are freezed or not)
%%%%% Output:  conf_new  the new configuration of the whole atomic system
%%%%%                      (includes the coordinates of all atoms and the information if they are freezed or not)

function conf_new = update_conf(vec,conf_old)

    conf_new = conf_old;
    conf_new(conf_old(:,4)==0,1:3) = reshape(vec,3,size(vec,2)/3)';

end