function [F,E] = CuH2(celldim,R)

%R=reshape(R,3,length(R)/3)'; %proper format (Nx3)

% THIS BLOCK WRITES PROPER INPUT (.con) FOR THE POTENTIAL
% note: rueit only works if two H atoms are included and placed at the end 
% of the Cu coordinates
z = zeros(length(R),1);
ind = linspace(1,length(R),length(R))';
mat = [R z ind];
fileid = fopen('tmp.con','w');
fprintf(fileid,' 0   Random Number Seed\n');
fprintf(fileid,' 0   Time\n');
formatspec= ' %4.16f %4.16f %4.16f\n';
fprintf(fileid,formatspec,celldim);
fprintf(fileid,formatspec,[90.0 90.0 90.0]);
formatspec= ' %d %d\n';
fprintf(fileid,formatspec,[0 0]);
formatspec= ' %d %d %d\n';
fprintf(fileid,formatspec,[length(R),0,1]); 
formatspec=' %d\n';
fprintf(fileid,formatspec,[2]);
formatspec=' %d %d\n';
fprintf(fileid,formatspec,[length(R)-2 2]); 
formatspec=' %4.16f %4.16f\n';
fprintf(fileid,formatspec,[63.5459999999999994 1.00792999999999999]);
formatspec = ' %10.14f %10.14f %10.14f %d %d \n';
fprintf(fileid,' Cu \n');
fprintf(fileid,' Components of Type 1 \n');
fprintf(fileid,formatspec,mat(1:end-2,:)');
fprintf(fileid,' H \n');
fprintf(fileid,' Components of Type 2 \n');
fprintf(fileid,formatspec,mat(end-1:end,:)');
fclose(fileid);
%INPUT BLOCK END

%RUN THE EXECUTABLE 

%create a temp status file (check if job is done)
fid = fopen('eam.tmp','w');
fprintf(fid,'0');
fclose(fid);

%unix('xterm -e /home/via9/bin/matlab_CuH2'); %RUN THE EXECUTABLE
unix('/u/03/okoisti2/unix/Desktop/GP-MEP/data_CuH2/mEAMCUH2'); %RUN THE EXECUTABLE


%I am not certain if matlab waits for the execution of the binary, thus
%for safety I've included that matlab checks if the job is done.
done = 0;
while done == 0
 pause(0.1); %check every 0.05 seconds if calculation is done
 %here it is assumed the calculations will never take longer than 0.1 sec
 %thus this loop will cycle at most 2 cycles, and actually can become the
 %computational bottle-neck. 
 fid = fopen('eam.tmp','r');
 done = fscanf(fid,'%d');
 fclose(fid);
end
% EXECUTABLE END

%GET RESULTS
fid=fopen('forces.out','r');
F=fscanf(fid,'%f',[4,inf])';  %fscanf is known to be very efficient, 
%compared to e.g. importdata and dlmread.Specifically, if you give exact
%structure and delimeters.
fclose(fid);
F=F(:,2:4);

fid=fopen('energy.out','r');
E=fscanf(fid,'%f',[1,1])'; 
fclose(fid);
%RESULTS END
end
