%%%%% visualize_path_true.m
%%%%% Copyright: Olli-Pekka Koistinen, Aalto University, 13.7.2017
%%%%%
%%%%% This script visualizes the true energy along a cubic spline
%%%%% interpolation of the path.
%%%%% 
%%%%% Input: R            coordinates of the images
%%%%%        pot_general  function giving the energy and gradient

N_im = size(R,1);
R_spline = spline((0:N_im-1)/(N_im-1),R',(0:0.1:N_im-1)/(N_im-1))';
[E_spline,G_spline] = pot_general(R_spline);
E_spline = E_spline - Elevel;
[E_images,G_images] = pot_general(R);
E_images = E_images - Elevel;

plot(1:0.1:N_im,E_spline,'r');
plot(1:N_im,E_images,'o','MarkerEdgeColor','r','MarkerFaceColor','r')
title('True energy along cubic spline interpolation of the path')
xlabel('image number')
