%%%%% tangent.m
%%%%% Copyright: Olli-Pekka Koistinen, Aalto University, 13.7.2017
%%%%%
%%%%% This function calculates the tangent of the path at the intermediate images.
%%%%% 
%%%%% Input:   R    coordinates of the images
%%%%%          E_R  energy at the images 
%%%%% Output:  Z    normalized tangent vectors of the path at the intermediate images

function Z = tangent(R,E_R)
    N_im = size(R,1);
    D = size(R,2);
    Z = zeros(N_im-2,D);
    for i = 2:(N_im-1)
        if E_R(i-1,1) < E_R(i,1) & E_R(i,1) < E_R(i+1,1)
            z = R(i+1,:)-R(i,:);
        elseif E_R(i-1,1) > E_R(i,1) & E_R(i,1) > E_R(i+1,1)
            z = R(i,:)-R(i-1,:);
        else
            zplus = R(i+1,:)-R(i,:);
            zminus = R(i,:)-R(i-1,:);
            dEmax = max(abs(E_R(i-1,1)-E_R(i,1)),abs(E_R(i+1,1)-E_R(i,1)));
            dEmin = min(abs(E_R(i-1,1)-E_R(i,1)),abs(E_R(i+1,1)-E_R(i,1)));
            if E_R(i-1,1) < E_R(i+1,1)
                z = dEmax*zplus + dEmin*zminus;
            else
                z = dEmin*zplus + dEmax*zminus;
            end
        end
        Z(i-1,:) = z/sqrt(sum(z.^2));
    end
end