%%%%% set_pairtype_mov.m
%%%%% Copyright: Olli-Pekka Koistinen, Aalto University, 11.7.2018
%%%%%
%%%%% This function sets pairtype indices for moving+moving atom pairs and
%%%%% gives the updated number of active pairtypes.
%%%%%
%%%%% Input:
%%%%%   atomtype_mov  atomtype indices for moving atoms (1 x N_mov)
%%%%%   pairtype      pairtype indices for pairs of atomtypes before the update (n_at x n_at)
%%%%%   n_pt          number of active pairtypes before the update
%%%%%
%%%%% Output:
%%%%%   pairtype      indices for pairs of atomtypes after the update (n_at x n_at) 
%%%%%   n_pt          number of active pairtypes after the update

function [pairtype,n_pt] = set_pairtype_mov(atomtype_mov,pairtype,n_pt)
    
    N_mov = size(atomtype_mov,2);
    for i = 1:N_mov-1
        at_i = atomtype_mov(i);
        for j = (i+1):N_mov
            at_j = atomtype_mov(j);
            if pairtype(at_i,at_j) == 0
                n_pt = n_pt + 1;
                pairtype(at_i,at_j) = n_pt;
                pairtype(at_j,at_i) = n_pt;
            end
        end
    end
    
end

