%%%%% rot_iter_mn.m
%%%%% Copyright: Olli-Pekka Koistinen, Aalto University, 9.7.2020
%%%%%
%%%%% This is an auxiliary function for the dimer method ('dimer.m').
%%%%% The dimer is rotated one step towards its minimum energy orientation
%%%%% according to the modified Newton method.
%%%%%
%%%%% Input:
%%%%%   R                     coordinates of the middle point of the dimer (1 x D)
%%%%%   orient                unit vector along the direction of the dimer (before rotation) (1 x D)
%%%%%   G01                   gradient at the middle point and image 1 of the dimer (before rotation) (2 x D)
%%%%%   potential             potential and gradient function
%%%%%   dimer_sep             dimer separation (distance from the middle point of the dimer to the two images)
%%%%%   T_anglerot            convergence threshold for the rotation angle
%%%%%   estim_Curv            if 1, an estimate for the curvature along the direction of the dimer after the rotation is calculated
%%%%%   rotinfo               structure array including necessary input information for the rotation method [irrelevant for this method]
%%%%%   
%%%%% Output:
%%%%%   orient_new            unit vector along the direction of the dimer after optimal rotation (1 x D)
%%%%%   Curv                  estimate for the curvature along the direction of the dimer after the rotation (empty if estim_Curv = 0)
%%%%%   R_obs                 coordinates of the new observed location (1 x D)
%%%%%   E_obs                 energy at the new observed location
%%%%%   G_obs                 gradient at the new observed location (1 x D)
%%%%%   rotinfo               structure array including necessary input information for the rotation method [irrelevant for this method]


function [orient_new,Curv,R_obs,E_obs,G_obs,rotinfo] = rot_iter_mn(R,orient,G01,potential,dimer_sep,T_anglerot,estim_Curv,rotinfo)
    F_rot = force_rot(G01,orient,dimer_sep);
	[orient_new,orient_rot_new,Curv,~,R_obs,E_obs,G_obs] = rotate_dimer(R,orient,G01,F_rot,potential,dimer_sep,T_anglerot,estim_Curv,0);
end
