%%%%% get_variance.m
%%%%% Copyright: Olli-Pekka Koistinen, Aalto University, 15.9.2017
%%%%%
%%%%% This function gives the variance of energy and gradient components
%%%%% at the images on the path.
%%%%%
%%%%% Input:   gp       GP model (as a GPstuff structure)
%%%%%          R        coordinates of the images on the path
%%%%%          L        lower triangular matrix of the Cholesky decomposition of the (noisy) training covariance matrix
%%%%%          KK       covariance matrix between the training data points and R
%%%%% Output:  VarE_R   variance of energy at the images on the path
%%%%%          VarG_R   variance of energy gradient components at the images on the path

function [VarE_R,VarG_R] = get_variance(gp,R,L,KK)
    n = size(R,1);
    D = size(R,2);
    R2 = [repmat(R,D+1,1),reshape(repmat(0:D,n,1),[],1)];
    Cov = gp_trcov(gp,R2);
    V = diag(Cov);
    v = L\KK;
    VarEG_R = V - sum(v'.*v',2);
    VarE_R = VarEG_R(1:n,:);
    VarG_R = reshape(VarEG_R(n+1:end,:),n,size(VarEG_R,1)/n-1);
end
