%%%%% demo_muller_brown_sNEB_QMVelocityVerlet.m
%%%%% Copyright: Olli-Pekka Koistinen, Aalto University, 1.8.2018
%%%%%
%%%%% This script shows how to use 'sNEB.m' with quick-min Velocity Verlet steps in a Muller-Brown example.

pot_general = @(R) muller_brown(R); % define the potential energy function

min1 = [-0.5582, 1.4417]; % define the first minimum point
min2 = [0.6235, 0.0280]; % define the second minimum point
N_im = 10; % define the number of images on the path
R_init = initialize_path_linear(min1,min2,N_im); % define the initial path
method_step = @(R,F_R,param_step,F_R_old,V_old,zeroV) step_QMVelocityVerlet(R,F_R,param_step,F_R_old,V_old,zeroV); % use quick-min Velocity Verlet to define the steps path relaxation
param_step = 0.01; % define the time step for the quick-min Velocity Verlet algorithm
k_par = 1; % define the parallel spring constant
k_perp = 1; % define the perpendicular spring constant
T_MEP = 0.01; % define the convergence threshold for the maximum norm of the force
T_CI = 0.01; % define the additional convergence threshold for the climbing image
T_CIon = 0.01; % define the convergence threshold after which the climbing image mode is turned on (0 if not used at all)
num_iter = 10000; % define the maximum number of iterations

% Call the sNEB function
[R,E_R,G_R,i_CI,E_R_acc,normF_R_acc,normFCI_acc] = sNEB(pot_general,R_init,method_step,param_step,k_par,k_perp,T_MEP,T_CI,T_CIon,num_iter);

% Plot the behaviour
figure
subplot(4,1,1)
title('Mean of norms of forces')
xlabel('iteration')
hold
plot(0:size(normF_R_acc,2)-1,mean(normF_R_acc,1))
subplot(4,1,2)
title('Maximum norm of force')
xlabel('iteration')
hold
plot(0:size(normF_R_acc,2)-1,max(normF_R_acc))
subplot(4,1,3)
title('Norm of force on the climbing image')
xlabel('iteration')
hold
plot(0:size(normF_R_acc,2)-1,normFCI_acc)
subplot(4,1,4)
title('Mean of energies')
xlabel('iteration')
hold
plot(0:size(E_R_acc,2)-1,mean(E_R_acc,1))
