%%%%% demo_muller_brown_dimer_lbfgsext.m
%%%%% Copyright: Olli-Pekka Koistinen, Aalto University, 26.1.2020
%%%%%
%%%%% This script shows how to use 'dimer.m' in a Muller-Brown example.

pot_general = @(R) muller_brown(R); % define the potential energy function

R_init = [-0.6978,0.5446] % define the initial middle point of the dimer
D = size(R_init,2);
orient_init = [-0.0830,0.9965]; % define the initial orientation of the dimer (unit vector along the direction of the dimer)
dimer_sep = 0.01; % define the dimer separation (distance from the middle point of the dimer to the two images)
method_rot = @rot_iter_lbfgsext; % use the conjugate gradient method for rotations
method_trans = @trans_iter_lbfgs; % use the conjugate gradient method for translations
param_trans = [0.1, 0.1]; % define a step length for convex regions and maximum step length
T_dimer = 0.01; % define the convergence threshold for the maximum component of the force acting on the middle point of the dimer
T_anglerot = 0.0873; % define the convergence threshold for the rotation angle
num_iter_rot = min(D,10); % define the maximum number of rotation iterations per translation
num_iter = 200; % define the maximum number of iterations

% Call the dimer function
[R,orient,E_R,G_R,R_all,E_all,G_all,E_R_acc,maxF_R_acc,obs_total] = dimer(pot_general,R_init,orient_init,dimer_sep,method_rot,method_trans,param_trans,T_dimer,T_anglerot,num_iter_rot,num_iter);

% Plot the behaviour
figure
subplot(2,1,1)
title('Maximum component of the force at the middle point')
xlabel('iteration')
hold
plot(0:size(maxF_R_acc,2)-1,maxF_R_acc)
subplot(2,1,2)
title('Energy at the middle point')
xlabel('iteration')
hold
plot(0:size(E_R_acc,2)-1,E_R_acc)
