function [R,obs_total] = demo_ORCA_dimer(i_reaction,i_dist,i_run)

%%%%% demo_ORCA_dimer.m
%%%%% Copyright: Olli-Pekka Koistinen, Aalto University, 26.1.2020
%%%%%
%%%%% This script shows how to use 'dimer.m' in an ORCA example.

if i_reaction == 1
    [conf1,symb] = readxyz('reactI.xyz'); 
    [conf2,symb] = readxyz('prodI.xyz');
end
if i_reaction == 2
    [conf1,symb] = readxyz('reactII.xyz'); 
    [conf2,symb] = readxyz('prodII.xyz');
end
if i_reaction == 3
    [conf1,symb] = readxyz('reactIII.xyz'); 
    [conf2,symb] = readxyz('prodIII.xyz');
end
if i_reaction == 4
    [conf1,symb] = readxyz('reactIV.xyz'); 
    [conf2,symb] = readxyz('prodIV.xyz');
end

Constr = zeros(length(conf1),1);
%Get them to same format as Olli-Pekka used
%to be able to use modified-conf2vec
conf1 = [conf1 Constr];
conf2 = [conf2 Constr];
conf = conf1; %the full system

symb2 = cell2mat(symb)';
pot_general = @(R) EORCA(R,conf,symb2); % define the potential energy function
load(sprintf('orients_ORCA%d.mat',i_reaction))
load(sprintf('MEP_ORCA%d.mat',i_reaction))
dist_sp = [0.02,0.05,0.1,0.2,0.3,0.4];
R_init = R_sp + dist_sp(i_dist)*orient_start(i_run,:); % define the initial middle point of the dimer
D = size(R_init,2);
orient_init = orient_init(i_run,:); % define the initial orientation of the dimer (unit vector along the direction of the dimer)
dimer_sep = 0.01; % define the dimer separation (distance from the middle point of the dimer to the two images)
method_rot = @rot_iter_lbfgsext; % use the conjugate gradient method for rotations
method_trans = @trans_iter_lbfgs; % use the conjugate gradient method for translations
param_trans = [0.1, 0.1]; % define a step length for convex regions and maximum step length
T_dimer = 0.01; % define the convergence threshold for the maximum component of the force acting on the middle point of the dimer
T_anglerot = 0.0873; % define the convergence threshold for the rotation angle
num_iter_rot = min(D,10); % define the maximum number of rotation iterations per translation
num_iter = 10000; % define the maximum number of iterations

% Call the dimer function
[R,orient,E_R,G_R,R_all,E_all,G_all,E_R_acc,maxF_R_acc,obs_total] = dimer(pot_general,R_init,orient_init,dimer_sep,method_rot,method_trans,param_trans,T_dimer,T_anglerot,num_iter_rot,num_iter);

%{
% Plot the behaviour
figure
subplot(2,1,1)
title('Maximum component of the force at the middle point')
xlabel('iteration')
hold
plot(0:size(maxF_R_acc,2)-1,maxF_R_acc)
subplot(2,1,2)
title('Energy at the middle point')
xlabel('iteration')
hold
plot(0:size(E_R_acc,2)-1,E_R_acc)
%}

end
