%%%%% demo_ORCA_NEB.m
%%%%% Copyright: Olli-Pekka Koistinen, Aalto University, 7.2.2019
%%%%%
%%%%% This script shows how to use 'NEB.m' in an ORCA example.

[conf1,symb] = readxyz('reactI.xyz'); 
[conf2,symb] = readxyz('prodI.xyz');
Constr = zeros(length(conf1),1);
%Get them to same format as Olli-Pekka used
%to be able to use modified-conf2vec
conf1 = [conf1 Constr];
conf2 = [conf2 Constr];
conf = conf1; %the full system

% 'pot_general' gives the potential energy and its gradient vector as a function of the atomic configuration.
% Each row of 'R' represents one configuration including the coordinates of the moving atoms:
% [x_1,y_1,z_1,x_2,y_2,z_2,...]
symb2 = cell2mat(symb)';
pot_general = @(R) EORCA(R,conf,symb2); 

min1 = conf2vec(conf1); % minimum point 1
min2 = conf2vec(conf2); % minimum point 2
N_im = 10; % define the number of images on the path
R_init = initialize_path_linear(min1,min2,N_im); % define the initial path
method_step = @(R,F_R,param_step,F_R_old,V_old,zeroV) step_QMVelocityVerlet(R,F_R,param_step,F_R_old,V_old,zeroV); % use quick-min Velocity Verlet to define the steps during path relaxation
param_step = 0.01; % define the time step for the quick-min Velocity Verlet algorithm
k_par = 1; % define the parallel spring constant

% 'T_MEP' defines the final convergence threshold for the 'maxnormF', which is
% the maximum of the norms of the NEB forces acting on the 'N_im'-2 intermediate
% images (i.e., the algorithm is stopped when the NEB force is below 'T_MEP' for all images).
T_MEP = 1;

% 'T_CI' defines an additional final convergence threshold for the
% climbing image, if the climbing image option is used.
% If you don't want to use a tighter convergence threshold for the climbing
% image, set 'T_CI' equal to 'T_MEP' (or larger, because
% the general threshold 'T_MEP' concerns also the climbing image).
T_CI = 0.001;

% 'T_CIon' defines a preliminary convergence threshold:
% When 'maxnormF' is below 'T_CIon', the climbing image mode is turned on.
% If you don't want to use climbing image at all, set 'T_CIon' to zero.
T_CIon = 1;

num_iter = 10000; % define the maximum number of iterations

% Call the NEB algorithm
[R,E_R,G_R,i_CI,E_R_acc,normF_R_acc,normFCI_acc] = NEB(pot_general,R_init,method_step,param_step,k_par,T_MEP,T_CI,T_CIon,num_iter);

%{
% Plot the behaviour
figure
subplot(4,1,1)
title('Mean of norms of NEB forces')
xlabel('iteration')
hold
plot(mean(normF_R_acc,1))
subplot(4,1,2)
title('Maximum norm of NEB force')
xlabel('iteration')
hold
plot(max(normF_R_acc))
subplot(4,1,3)
title('Norm of NEB force on the climbing image')
xlabel('iteration')
hold
plot(normFCI_acc)
subplot(4,1,4)
title('Mean of energies')
xlabel('iteration')
hold
plot(mean(E_R_acc,1))
%}
