%%%%% demo_CuH2_NEB2.m
%%%%% Copyright: Olli-Pekka Koistinen, Aalto University, 22.2.2019
%%%%%
%%%%% This script shows how to use 'NEB2.m' in a CuH2 example.

load('CuH2_idpp8_villi.mat')

% 'pot_general' gives the potential energy and its gradient vector as a function of the atomic configuration.
% Each row of 'R' represents one configuration including the coordinates of the moving atoms:
% [x_1,y_1,z_1,x_2,y_2,z_2,...]
pot_general = @(R) ECuH2(R,conf); % define the potential energy function
min1 = R_init(1,:);
min2 = R_init(end,:);

N_im = size(R_init,1); % define the number of images on the path
%R_init = initialize_path_linear(min1,min2,N_im); % define the initial path
method_step = @(R,F_R,param_step,F_R_old,V_old,zeroV) step_QMVelocityVerlet(R,F_R,param_step,F_R_old,V_old,zeroV); % use quick-min Velocity Verlet to define the steps during path relaxation
param_step = 0.1; % define the time step for the quick-min Velocity Verlet algorithm
method_force = @(R,E_R,G_R,param_force,CI_on) force_NEB2(R,E_R,G_R,param_force,CI_on); % use regular NEB force
param_force = 1; % define parallel spring constant
%method_force = @(R,E_R,G_R,param_force,CI_on) force_sNEB2(R,E_R,G_R,param_force,CI_on); % use sNEB force
%param_force = [1,1]; % define parallel and perpendicular spring constants

% 'T_MEP' defines the final convergence threshold for 'maxmaxG_R_perp', which is the maximum component
% of gradient perpendicular to the path tangent at any of the 'N_im'-2 intermediate images
% (i.e., the algorithm is stopped when the maximum component of perpendicular gradient is below 'T_MEP' for all images).
T_MEP = 0.3;

% 'T_CI' defines an additional final convergence threshold for 'maxG_CI', which is the maximum component
% of gradient at the climbing image, if the climbing image option is used.
T_CI = 0.01;

% 'T_CIon' defines a preliminary convergence threshold:
% When 'maxmaxG_R_perp' is below 'T_CIon_gp', the climbing image mode is turned on.
% If you don't want to use climbing image at all, set 'T_CIon' to zero.
T_CIon = 1;

num_iter = 10000; % define the maximum number of iterations

quatern = 0;

% Call the NEB algorithm
[R,E_R,G_R,i_CI,E_R_acc,maxG_R_perp_acc,maxG_CI_acc] = NEB2(pot_general,R_init,method_step,param_step,method_force,param_force,T_MEP,T_CI,T_CIon,num_iter,quatern);


