function [E,G] = Etip4p(R,conf)


Angtoau = 1.8897259885789;
box = [13.52118,15.61292,25.059136]*Angtoau; %if the system is changed,
%the box size will have to be changed accordingly.
N_T = size(conf,1);
num_im = size(R,1);
dim = size(R,2);
E = zeros(num_im,1);
G = zeros(num_im,dim);
for i = 1:num_im
    conf = update_conf(R(i,:),conf);
    x = reshape(conf(:,1:3),N_T,3);
    [Gi,Ei,vir] = tip4p(box,x);
    E(i,1) = Ei;
    Gi = -Gi(conf(:,4)==0,:);
    Gi = reshape(Gi',1,size(Gi,1)*3);
    G(i,:) = Gi;
end
end

