[X1,X2] = meshgrid(-1.5:0.05:1,-0.5:0.05:2); % this defines the area and resolution
E = zeros(size(X1,1),size(X1,2));
G1 = zeros(size(X1,1),size(X1,2));
G2 = zeros(size(X1,1),size(X1,2));
for i = 1:size(X1,1)
    for j = 1:size(X1,2)
        [E_temp,G_temp] = muller_brown([X1(i,j),X2(i,j)]);
        E(i,j) = E_temp;
        G1(i,j) = G_temp(1);
        G2(i,j) = G_temp(2);
    end
end
pcolor(X1,X2,E),shading flat;
caxis([-0.14 0.05]) % this defines the colour scale for the potential
axis equal tight;
title('Muller-Brown potential')
colorbar;
figure()
pcolor(X1,X2,G1),shading flat;
caxis([-0.5 0.5]) % this defines the colour scale for the x gradient
axis equal tight;
title('Derivative with respect to x-axis')
colorbar;
figure()
pcolor(X1,X2,G2),shading flat;
caxis([-0.5 0.5]) % this defines the colour scale for the y gradient
axis equal tight;
title('Derivative with respect to y-axis')
colorbar;