%%%%% free_nearest_freezed_atom_BM.m
%%%%% Copyright: Olli-Pekka Koistinen, Aalto University, 13.7.2017
%%%%%
%%%%% This script frees the nearest freezed atom from the lower atom layers
%%%%% and creates new start and end configurations for the BM transition
%%%%% with three more degrees of freedom.
%%%%% The distances are calculated from the location where one of the atoms
%%%%% is pushed away and replaced by another one during the transition
%%%%% (i.e. the centre of the essential movements).

old_num_free_atoms = 20;

load(sprintf('conf_BM%d.mat',old_num_free_atoms));
eval(sprintf('start_conf_old = start_conf_BM%d_relax;',old_num_free_atoms));
eval(sprintf('end_conf_old = end_conf_BM%d_relax;',old_num_free_atoms));
num_atoms = size(start_conf_old,1);
distances = zeros(num_atoms,1);
for i = 1:num_atoms
    distances(i,1) = norm(start_conf_old(i,1:3)-[10.3877,7.5280,14.5727]);
    if start_conf_old(i,4) == 0
        distances(i,1) = inf;
    end
end
[min_distance,min_index] = min(distances);
eval(sprintf('start_conf_BM%d = start_conf_old;',old_num_free_atoms+1));
eval(sprintf('end_conf_BM%d = end_conf_old;',old_num_free_atoms+1));
eval(sprintf('start_conf_BM%d(min_index,4) = 0;',old_num_free_atoms+1));
eval(sprintf('end_conf_BM%d(min_index,4) = 0;',old_num_free_atoms+1));
eval(sprintf('[start_conf_BM%d_relax,pots1] = relax_initial_conf(start_conf_BM%d);',...
    old_num_free_atoms+1,old_num_free_atoms+1));
eval(sprintf('[end_conf_BM%d_relax,pots2] = relax_initial_conf(end_conf_BM%d);',...
    old_num_free_atoms+1,old_num_free_atoms+1));
eval(sprintf('save(''conf_BM%d.mat'',''start_conf_BM%d'',''end_conf_BM%d'',''start_conf_BM%d_relax'',''end_conf_BM%d_relax'');',old_num_free_atoms+1,...
    old_num_free_atoms+1,old_num_free_atoms+1,old_num_free_atoms+1,old_num_free_atoms+1));