#!/bin/bash

#SBATCH -N 1 
#SBATCH --tasks-per-node=1
#SBATCH --time=288:00:00
#SBATCH -p omnip
#SBATCH --job-name=LennardJones

#Either input a scriptname or leave blank (as is)
scriptname=
scratchloc=/scratch

# # # JOB SCRIPT BEGINS HERE # # #

module load matlab/R2016a
shopt -s nullglob

cd ${SLURM_SUBMIT_DIR}

if [ ${#scriptname} -eq 0 ]; then
for ext in m; do
   files=( *."$ext" )
   a=${#files[@]}
done
if (( $a == 1 ));then
     scriptname=$files
     echo "Submitted: $scriptname"
elif (( $a == 0 ));then
     echo "no .m file found"
else
     echo "Error: Multiple .m files"
     exit
fi
fi
echo "Job started at: `date`"

# Sort out the list of processors
echo ${SLURM_NODELIST} 
echo "This job runs on the following ${NPROCS} processors:"

#Create scratch
if [ ! -d $scratchloc/$USER ]
then
   mkdir -p $scratchloc/$USER
fi
tdir=$(mktemp -d $scratchloc/$USER/matlab__$SLURM_JOBID-XXXX)
chmod +xr $tdir
if [ ! -d "$tdir" ]; then
echo "Scratch not found"
exit
fi
#Copy things to scratch dir
#Copying submitted inputfile
cp $SLURM_SUBMIT_DIR/$scriptname $tdir/

#Go to scratch dir
cd $tdir

echo $scriptname
matlab -nodisplay -nosplash   < $scriptname #> results.out

#cp $tdir/results.out $SLURM_SUBMIT_DIR/
#cp $tdir/*.mat $SLURM_SUBMIT_DIR/
cp -r $tdir/* $SLURM_SUBMIT_DIR/

rm -rf $tdir
echo "Job ended at: `date`"

