function [F,E] = LennardJonesSP(R)

% Lennard jones (clusters) Matlab implementation for GPR-NEB.
% Input: Atomic Configuration: R (natom, 3)
% Output: Energy: E (double) and atomic forces: F (natom, 3) (not gradient) 


%LJ parameters (hard-coded)
sigma = 1.0;
eps = 1.0;

%get # atoms
[natoms, ~] = size(R);

%pre-allocate
E = 0.0;
F = zeros(natoms,3);

%start calculation
for i = 1:natoms
    x0 = R(i,1);
    y0 = R(i,2);
    z0 = R(i,3);
    for j = i+1:natoms
        dx = R(j,1)-x0;
        dy = R(j,2)-y0;
        dz = R(j,3)-z0;
        rdist = sqrt(dx*dx+dy*dy+dz*dz);
        tterm = (sigma / rdist)^6;
        E = E + 4*eps * tterm * (tterm - 1);
        gradi = 24*eps * tterm / rdist * (1 - 2*tterm);
        Fx = gradi * dx/rdist;
        Fy = gradi * dy/rdist;
        Fz = gradi * dz/rdist;
        
        F(i,1) = F(i,1) + Fx;
        F(j,1) = F(j,1) - Fx;
        
        F(i,2) = F(i,2) + Fy;
        F(j,2) = F(j,2) - Fy;
        
        F(i,3) = F(i,3) + Fz;
        F(j,3) = F(j,3) - Fz;
    end
end


end
