% testing orca wrapper
clear all

inputfile = '/home/via9/SOFTWARE/GPR_NEB_MATLAB/atomic_GP-sNEB_2018_08_01/data_ORCA/orca.inp';
outputfile = '/home/via9/SOFTWARE/GPR_NEB_MATLAB/atomic_GP-sNEB_2018_08_01/data_ORCA/orca.out';
symb = ['C', 'C', 'O', 'O', 'H', 'H', 'H', 'H'];
natoms = length(symb);

% calculate reactant state
R = readxyz('react_ready.xyz');
wrORCAinput(inputfile, symb, R); % Write input file
runORCA(inputfile, outputfile); % run orca code
[grad, E]=readORCAoutput(outputfile, natoms); %read output file 
cleanORCAcalculation(outputfile); % clean up after calculation


% calculate product state
R = readxyz('prod_ready.xyz');
wrORCAinput(inputfile, symb, R); % Write input file
runORCA(inputfile, outputfile); % run orca code
[grad2, E2]=readORCAoutput(outputfile, natoms); %read output file 
cleanORCAcalculation(outputfile); % clean up after calculation