function [E,G] = EORCA(R, conf, symb)

% WRAPPER TO INTERFACE GPR-NEB WITH ORCA 4.1 CALCULATOR
% R should be in angstroem
% E and G are returned in eV and eV/Angstroem

% any desired path can be chosen for the input and output files
inputfile = 'orca.inp';
outputfile = 'orca.out';
%symb = ['C','C','O','N','N','H','H','H','H'];

N_T = size(conf,1);
num_im = size(R,1);
dim = size(R,2);
E = zeros(num_im,1);
G = zeros(num_im,dim);
for i = 1:num_im
    conf = update_conf(R(i,:),conf);
    x = reshape(conf(:,1:3),N_T,3);
    
    wrORCAinput(inputfile, symb, x); % Write input file
    runORCA(inputfile, outputfile); % run orca code
    [Gi, Ei]=readORCAoutput(outputfile, N_T); %read output file 
    cleanORCAcalculation(outputfile); % clean up after calculation


    E(i,1) = Ei;
    Gi = Gi(conf(:,4)==0,:);
    Gi = reshape(Gi',1,size(Gi,1)*3);
    G(i,:) = Gi;
end
end

