function [E,G] = ECuH2_log6b(R,conf)

% Wrapper routine to make CuH2 call compatible with GP-MEP.

%define cell dimension (if the system is changed, these numbers will change)
%box = [21.7139999999999986, 15.3541170000000005, 111.5155869999999965];
box = [15.3455999999999992 21.7020000000000017 100.0000000000000000];

expR1 = R(:,1) - 8.3122;
expR3 = R(:,3) - 6.9754;
expR4 = -R(:,4) + 8.3122;
expR6 = R(:,6) - 6.9754;

%the typical convert style, as in the Morse-potential
N_T = size(conf,1);
num_im = size(R,1);
dim = size(R,2);
E = zeros(num_im,1);
G = zeros(num_im,dim);

for i = 1:num_im
    conf = update_conf(R(i,:),conf);
    x = reshape(conf(:,1:3),N_T,3);
    [Gi,Ei] = CuH2(box,x);
    E(i,1) = Ei;
    Gi = -Gi(conf(:,4)==0,:);
    Gi = reshape(Gi',1,size(Gi,1)*3);
    G(i,:) = Gi;
end
G = [G(:,1).*expR1,G(:,2),G(:,3).*expR3,-G(:,4).*expR4,G(:,5),G(:,6).*expR6];
end

