%================================================
% = 	      for GLOBALSADD Version: xxx       =
% = 	Simulation Initial configuration file	=
% = 	Parameter values to set up simulation:	=
%================================================

% *****************
% *  Simulation:  *
% *****************

    desired_number_sp = 10500;
    parall_search_per_min=2; % number of SP-search per minimum(should be function of n-dimensions)
    max_attempts = 10; % Total number of searches = parall_search_per_min * max_attempts
    real_n_cores= 2; % number of CPU that matlab will request.

    RUNTIME = 86400*10; 
    absTol = 0.1;% tolerance to consider two structures the same
    delta = 0.5; % maximum step size 
    sigma = 0.1; % standard deviation for the gaussian
    a_to_disp = 7; % number of atoms to be displaced
    pick_rand_atoms = false; 
    displace_radius = 3.3; 
    get_ini_guess = true;% if true the initial configuration of atoms will be read 
                         % (the paths have to be provided in variable 'filename' inside 'globalsadd_v90_morse.m')
    bench_energy = 4.0; % all saddles bellow this E will be count.
    ref_energy = 1.5;% this energy can be used as stopping criterium for the web benchmark. 
    distribution = 2;

    f_name = 'morse';
    write_out_to_hdd = true; % write screen output to a file    
    new_displacement_per_tune = true; % true=> each tunes use different starting oints for SP-searches

% *******************
% *  Hyper sphere:  *
% *******************    
    
    disp_by_hypersphere_method = true;
    %----------------------------------:
     hyper_rad0 = 0.1; % initial hiper radius
     read_from_database = false;
     self_learning_hyper_rad = true; % true -> uses variable hyper R. flase -> uses constant hyper R = hyper_rad0.
     automatic_self_learning = true;% false means a predifined scheduled for vary hyper R is used.
                                   % true means a distances to sp and lamda zero surfaces are used to vary hype R.
     self_learning_scheme = 2; % different ways to stimate change in hyper R
     mix_prev_hyper_rad = true; % true -> average prev hyper R in the schemes(smoother transition from one hyper R to next one)
     sort_displacements = true; % true means disp are sorted by furthest distances and choosen acordinly
                                % false means the points are choosen ramdomly.                                   

% *****************
% *  Minimizer:   *
% *****************

    min_method = 'LBFGS'; % LBFGS or CG
    %min_method = 'CG'; % LBFGS or CG
    memory_size = 60; % for LBFGS method
    finite_diff_step = 1e-4; % Finite diff to stimate 2nd order derivative 
    cg_iter_max = 500; % Maximun number of CG iterations     
    ls_iter_max = 1; % Maximum number of Line search iterations
    cg_err = 1e-3; % CG error tolerance 
    ls_err = 1e-2; % Line search error tolerance
    max_step_size = delta ; % delta is defined in globalsadd
    
    RESET = false; % if true CG is reset when lambda zero boundary is crossed. 
    get_min_mode_ = true;
    normalize_direction = true; % if true the search direction is normalized
    maximum_speed = false;  
    dE_max = 480.0; % energy cutoff to abort saddle searches
    obligate_move = true; 
    use_same_formula = false;% true means using same min. mode formula when first exit + area
    lam = []; % determines how much of the gradient is mixed with a ramdom 
               % direction to escape positive area when get_min_mode = false
    %lam = 1; % this combination uses the min mode to esc '+' area
    %alf = 0;
    alf = []; % if equal zero -gradient is used as direction                                         
    n_intentos = 0; % Attempts to force the system staying inside SP basin of attraction.
    avoid_stuck_in_min = true;

% ***********************************
% *  Library: Lanczos, Davidson     *
% ***********************************
lib_name=''; % if a 'lib_name' and 'lib_path' are empty strings defaults will be used
lib_path='';
    lanc_iter = 8;
    lanc_abs_tol = 0.01;
    lanc_finite = finite_diff_step;
    save_lanczos_call = true; 
    save_lanczos_factor = 50.0; % procent of maximum step size (recomended 50% to 85% for max_step_size=0.5 and LBFGS)
    
% ******************
% * Conjugate Grad *
% ******************

    beta_formula=9; % 1->Hestenes and Stiefel, 2->Polak-Ribiere, 3->Liu and Storey
                  % 4->Dai-Yuan, 5->Fletcher-Reeves, 6->conjugate descent
                  % 7->Hestenes-Stiefel + Dai-Yuan, 8->Polak-Ribiere + Fletcher-Reeves, 
                  % 9->Liu-Storey + conjugate descent
    modified_CG = false; % Uses a modified formula to compute search direction.

    e_tol = 1e-8; % tolerance to evaluate uniform descent condition in CG
    get_min_mode_lineSearch = true;

% End
