function [ind_ex, corrected_v_list, corrected_f_v_list, corrected_v_min, corrected_run_count, same ]= ...
                    are_vectors_equal_morse_v3...
                (v_list, f_v_list, absTol, v_min, run_count)
            
% Under development to expand globalsad output
% check parameters pased as function arguments
% if nargin<5 % means minima list is passed, v_min not passed
switch nargin  
    
 case 3 % minima list passed
%  ******** BEGIN CASE 3 ******
    % disp('minima list passed')
    [r, c] = size(v_list); % get array dimensions c = number of min/sp
    if (c < 2)
        
        %disp('Warning! Only one vector in the comparison list ')
        % validate the function and exit
        ind_ex = [];
        corrected_v_list = v_list;
        corrected_f_v_list = f_v_list;
        corrected_v_min = [];
        corrected_run_count = [];
        same = false;


    elseif ~isvector(f_v_list)  % if not a vector raise an error and stop

        err = MException('ResultChk:OutOfRange', ...
            'expecting a vector and matrix received');
        throw(err)

    elseif length(f_v_list)==c % No problem, do everything
    %     disp('no problem!!')
        [ ind_ex(:,2), ind_ex(:,1) ] = find(tril(ones(c), -1)); % Conbination for compare 


        % Square of the distance between atoms
        distance = ...
        ( v_list((1:3:r), ind_ex(:,1)) - v_list((1:3:r), ind_ex(:,2)) ).^2 + ...
        ( v_list((2:3:r), ind_ex(:,1)) - v_list((2:3:r), ind_ex(:,2)) ).^2 + ...
        ( v_list((3:3:r), ind_ex(:,1)) - v_list((3:3:r), ind_ex(:,2)) ).^2;    

        % When comparing 2 configurations, the distance between every atom in
        % confi No1 and they corresponding atoms in confi No2 are compared to
        % the tolerance. If any of the distances is larger than the tolerance
        % the configuration is considered to be different:
        %^same =  abs(distance) < absTol*absTol ; %  
        same = all( distance < absTol*absTol) ;


        corrected_v_list = v_list;
        corrected_v_list(:, ind_ex(same, 2)) = NaN; % Remove from list repeated vectors

        corrected_f_v_list = f_v_list;
        corrected_f_v_list(ind_ex(same, 2)) = NaN; % Remove from list repeated vectors 


        % ******* Sort the list ascending ****
        [corrected_f_v_list, in_dex] = sort(corrected_f_v_list);
        corrected_v_list = corrected_v_list(:,in_dex);

        corrected_v_min = NaN;
        corrected_run_count = NaN;

    else % is vector but different sise than expected: error and stop

        err = MException('ResultChk:OutOfRange', ...
            'Wrong vector length');
        throw(err)

    end 
%  ******** END CASE 3 ******
    
 case 5 % SP list passed
%  ******** BEGIN CASE 5 ******
        
    [r, c] = size(v_list); % get array dimensions c = number of min/sp, r = number of components
    if (c < 2) % Only one vector in the comparison list
        
        % validate the function and exit
        ind_ex = [];
        corrected_v_list = v_list;
        corrected_f_v_list = f_v_list;
        corrected_v_min = v_min;
        corrected_run_count = run_count;
        same = false;    

    elseif ~isvector(f_v_list)  % function values are not as a vector
        
        %raise an error and stop
        err = MException('ResultChk:OutOfRange', ...
            'expecting a vector and matrix received');
        throw(err)

    elseif length(f_v_list)==c % No problem, do everything

        % Sort all data ascending
            % code here

        [ ind_ex(:,2), ind_ex(:,1) ] = find(tril(ones(c), -1)); % Conbination for compare 


        % Square of the distance between atoms
        distance = ...
        ( v_list((1:3:r), ind_ex(:,1)) - v_list((1:3:r), ind_ex(:,2)) ).^2 + ...
        ( v_list((2:3:r), ind_ex(:,1)) - v_list((2:3:r), ind_ex(:,2)) ).^2 + ...
        ( v_list((3:3:r), ind_ex(:,1)) - v_list((3:3:r), ind_ex(:,2)) ).^2; 

        % When comparing 2 configurations, the distance between every atom in
        % confi No1 and its corresponding atom in confi No2 are compared to
        % the tolerance. If any of the distances is larger than the tolerance
        % the configuration is considered to be different:  
  
        same = all( distance < absTol^2) ; % Does not work for only one atom(such a case never happens)

        corrected_v_list = v_list;
        corrected_v_list(:, ind_ex(same, 2)) = NaN; % Remove from list repeated vectors

        corrected_f_v_list = f_v_list;
        corrected_f_v_list(ind_ex(same, 2)) = NaN; % Remove from list repeated vectors 

        corrected_v_min = v_min;
        corrected_v_min(:, ind_ex(same, 2)) = NaN; % Remove from list repeated vectors

        corrected_run_count = run_count;
        corrected_run_count(ind_ex(same, 2)) = NaN; % Remove from list repeated vectors 


%         % ******* Sort the list ascending ****
%         % SORT IS COMMENTED BECAUSE IS NOT NEEDED IN 
%             [corrected_f_v_list, in_dex] = sort(corrected_f_v_list);
%             corrected_v_list = corrected_v_list(:,in_dex);
%             corrected_v_min = corrected_v_min(:,in_dex);
%             corrected_run_count = corrected_run_count(in_dex);
        
%         disp('****')
%         disp(ind_ex)
%         disp('****')
  


    else % is vector but different size than expected: error and stop

        err = MException('ResultChk:OutOfRange', ...
            ['Wrong vector length. Expecting ',num2str(c), '  received  ', ...
            num2str(length(f_v_list))]);
        throw(err)

    end
%  ******** CASE 5 ******  
   
 otherwise % means error in input
    disp('error en entrada de datos')
end    
% Sort the arrays by the lowest value in f_v_list


