%Try 20 

loadlibrary('libmorse','morse'); % load the library for calculating the Morse potential (this can be commented if already done)

%setting minima, initial path, and potential energy function
load('conf8_BM7.mat');
conf = start_conf_BM7_relax; % any configuration to serve as a frame (freezed atoms stay the same)
min1 = conf2vec(start_conf_BM7_relax); % minimum point 1
min2 = conf2vec(end8_conf_BM7_relax); % minimum point 2
pot_general = @(R) morsepotential(R,conf); % potential energy function

[E_min1,G_min1] = pot_general(min1); % energy and gradient at minimum point 1
[E_min2,G_min2] = pot_general(min2); % energy and gradient at minimum point 2
Elevel = min([E_min1,E_min2]); % zero level of energy is set to the lower minimum
E_min1 = E_min1 - Elevel;
E_min2 = E_min2 - Elevel;

num_im = 7; % define the number of images on the path
R_init = initialize_path_linear(min1,min2,num_im); % define the initial path
method_step = @(R,F_R,param_step,F_R_old,V_old,iter) step_QMVelocityVerlet(R,F_R,param_step,F_R_old,V_old,iter); % use quick-min Velocity Verlet to define the steps path relaxation
param_step = 0.01; % define the time step for the quick-min Velocity Verlet algorithm
k_par = 1; % define the parallel spring constant
k_perp = 1; % define the perpendicular spring 

% 'maxnormF_conv' defines the final convergence limit for the 'maxnormF', which is
% the maximum of the accurate norms of the forces acting on the 'num_im'-2 intermediate
% images (i.e., the algorithm is stopped when the accurate force is below 'maxnormF_conv' for all images).
maxnormF_conv = 0.001;

% 'normFCI_conv' defines an additional final convergence limit for the
% climbing image, if the climbing image option is used.
% If you don't want to use a tighter convergence limit for the climbing image, set 'normFCI_conv' equal to 'maxnormF_conv' (or larger, because
% the general limit 'maxnormF_conv' concerns also the climbing image).
normFCI_conv = 0.001;

% 'maxnormF_CIon_gp' defines a preliminary convergence limit for each GP relaxation phase:
% When the approximated 'maxnormF' is below 'maxnormF_CIon', the climbing
% image option is turned on.
% If you don't want to use climbing image at all, set 'maxnormF_CIon' to zero.
maxnormF_CIon_gp = 0.001;

% If 'divisor_conv_gp' is set to zero, the default convergence limit for each GP relaxation
% phase for the approximated 'maxnormF' on the approximated energy surface is 1/10 of the lowest final limit.
% To save inner iterations during the first GP relaxation phases, one can set
% a positive value for 'divisor_conv_gp', so that the GP convergence limit will be
% 1/'divisor_conv_gp' of the smallest accurate norm of force obtained so far
% on any of the 'num_im'-2 intermediate images, but not less than 1/10 of the lowest final limit.
% If the approximation error is assumed to not decrease more than that during one outer iteration,
% there is no need for more accurate relaxation on an approximated surface.
divisor_conv_gp = 10;

% 'disp_max' defines the maximum displacement of image from the nearest evaluated image
% relative to the distance between the two minimum points.
% Thus, the last inner step is rejected and the GP relaxation phase stopped if, for any image, the distance
% to the nearest evaluated image is larger than 'disp_max' times the distance between the two minimum points.
disp_max = 0.5;

% If 'start_from_latest' option is set on (1), each GP relaxation phase is started from the latest converged path.
%   (If climbing image is used, each GP relaxation phase is started from the latest converged equal-interval-path,
%   and the CI phase started from the latest converged CI-path if CI is unchanged (otherwise the from the converged
%   equal-interval-path).)
% If 'start_from_latest' option is set off (0), each GP relaxation phase is started from the initial path 'R_init'.
%   (If climbing image is used, the CI phase is continued from the converged equal-interval path.)
% Starting each round from the initial path may improve stability (and decrease outer iterations),
% but setting 'start_from_latest' option on may decrease the amount of inner iterations during the GP relaxation phases.
start_from_latest = 0;

num_bigiter = 200; % define the maximum number of outer iterations (new sets of observations)
num_iter = 10000; % define the maximum number of inner iterations (steps during a relaxation phase)

% 'num_hess' defines the number of outer iterations using the "virtual Hessian",
% i.e., additional observations around the minimum points. The "virtual Hessian"
% may slow down the GP computations especially in high-dimensional cases,
% but they may give useful information in the beginning.
% They usually bring no gain after 4 outer iterations.
% By setting 'num_hess' to zero, the "virtual Hessian" is set off.
num_hess = 0;
eps_hess = 0.001; % defines the distance of the additional points from the minimum points

% Define here the GP model by choosing the covariance function family and the
% observation model (likelihood). The hyperparameters of the GP model will
% be optimized before each relaxation phase, unless 'prior_fixed' is set
% (like here for the observation noise 'sigma2'). If the prior is left out,
% an uninformative default prior is used.

% 'gpcf_constant' defines a constant covariance function, which has a
% similar effect as integration over an unknown constant mean function
% having a Gaussian prior distribution with variance 'constSigma2'.
% Thus, adding this to the covariance function gives the mean level of the GP
% more space to vary.
cfc = gpcf_constant('constSigma2',100,'constSigma2_prior',prior_fixed);

% 'gpcf_sexp' defines a squared exponential covariance function which favours
% smooth functions. The hyperparameter 'magnSigma2' controls the magnitude
% of the overall variation of the function, and 'lengthScale' defines how fast the function
% can chance. 'lengthScale' can be the same for all dimensions (when the
% initial value is scalar) or a vector including an independent value for
% each dimension. In high-dimensional cases a shared 'lengthScale' may be better identifiable.
cfse = gpcf_sexp('lengthScale',1);
%cfse = gpcf_sexp('lengthScale',ones(size(min1)));

% 'lik_gaussian' defines a Gaussian noise model. Here, we assume that the observations
% are accurate, so 'sigma2' should be set small. However, if it is set too
% small, numerical issues may arise.
lik = lik_gaussian('sigma2', 1e-8, 'sigma2_prior', prior_fixed);

% 'gp_set' defines the GP model. Here, the covariance function 'cf' is
% defined as the sum of 'cfc' and 'cfse' defined above. To be able to use
% derivative observations, 'derivobs' needs to be set to 'on'.
gp = gp_set('cf', {cfc, cfse}, 'lik', lik, 'derivobs', 'on', 'jitterSigma2', 0);

% 'optimset' defines the tolerances used in optimization (of the GP hyperparameters).
opt = optimset('TolFun',1e-4,'TolX',1e-4,'display','off');

% Define the optimization function for the GP hyperparameter optimization.
% '@fminscg' may be more stable, but slower than '@fminlbfgs'.
optimf = @fminscg;

%Calling GP-sNEB algorithm
[R,E_R,G_R,i_CI,gp,R_all,E_all,G_all,obs_at,E_R_ae,E_R_gp,normF_R_ae,normF_R_gp,normFCI_ae,normFCI_gp,param_gp,times_bigiter,times_iter,conditions] = ...
             GP_sNEB_oneim(pot_general,R_init,method_step,param_step,k_par,k_perp,maxnormF_conv,normFCI_conv, ...
             maxnormF_CIon_gp,divisor_conv_gp,disp_max,start_from_latest,num_bigiter,num_iter,num_hess,eps_hess,gp,opt,optimf);

% Plot the behaviour
figure
subplot(4,1,1)
title('Mean of norms of forces (GP approximation)')
xlabel('iteration')
hold
plot(mean(normF_R_gp,1))
plot(obs_at,mean(normF_R_ae,1),'o')
subplot(4,1,2)
title('Maximum norm of force (GP approximation)')
xlabel('iteration')
hold
plot(max(normF_R_gp))
plot(obs_at,max(normF_R_ae),'o')
subplot(4,1,3)
title('Norm of force on the climbing image (GP approximation)')
xlabel('iteration')
hold
plot(normFCI_gp)
plot(obs_at,normFCI_ae,'o')
subplot(4,1,4)
title('Mean of energies (GP approximation)')
xlabel('iteration')
hold
plot(mean(E_R_gp,1))  
plot(obs_at,mean(E_R_ae,1),'o')


% find the saddle point with GP Newton-Rapshon
R_init = R(i_CI+1,:);
E_R_init = E_R(i_CI+1,:);
G_R_init = G_R(i_CI+1,:);
[E_min1,G_min1] = pot_general(min1); % energy and gradient at minimum point 1
[E_min2,G_min2] = pot_general(min2); % energy and gradient at minimum point 2
Elevel = min([E_min1,E_min2]);
normG_conv = 0.01;
Num_bigiter = 1000;
Num_iter = 1000;
eps_Hess = 1e-6;
[R_sp,E_R_sp,G_R_sp,H_R_sp_gp,stdH_R_sp_gp] = GP_newton_rapshon(pot_general,Elevel,...
    R_init,E_R_init,G_R_init,gp,R_all,E_all,G_all,normG_conv,Num_bigiter,Num_iter,eps_Hess,opt,optimf);
