function model = ss_unpak(model, w, pnames)
% SS_UNPAK - Model parameters from vector to model
%
% Syntax:
%   model = ss_unpak(model, w, pnames)
%
% In:
%   model  - Stucture of state space model
%   w      - Optimized parameter values
%   pnames - Locations of optimized parameters in model 
%
% Out:
%   model       - model with new values w
%
% Description:
%   w and pnames should be originally formed by:
%
%     [model, w0, pnames] = ss_pak(model)
%
%   and model should not be modified after that. Every time model is 
%   modified, should be done as follows, before using this function,
%
%     model = ss_set(model);
%     [model, w0, pnames] = ss_pak(model);
%
%   and then this function can be used.
%
% See also:
%   SS_PAK, SS_SET, SS_STACK
%
% Copyright:
%   2013 Jukka Koskenranta 
%
% This software is distributed under the GNU General Public
% License (version 3 or later); please refer to the file
% License.txt, included with the software, for details.

%%

  % Check inputs
  if nargin < 3 || isempty(pnames), [~,pnames] = ss_pak(model); end
  
  % For each parameter
  for j=1:length(w)
    if(pnames{j,1} ==0)
        model.sigma2 = w(j);
    else
        model.ss{pnames{j,1}}.(pnames{j,2}) = w(j);
    end
  end