/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import scala.Function1;
import scala.Function1$class;
import scala.PartialFunction$class;
import scala.Serializable;
import scala.collection.CustomParallelizable;
import scala.collection.CustomParallelizable$class;
import scala.collection.GenIterable$class;
import scala.collection.GenIterableLike$class;
import scala.collection.GenSeq$class;
import scala.collection.GenSeqLike$class;
import scala.collection.GenTraversable$class;
import scala.collection.GenTraversableLike$class;
import scala.collection.GenTraversableOnce$class;
import scala.collection.IndexedSeq$class;
import scala.collection.IndexedSeqLike$class;
import scala.collection.Iterable$class;
import scala.collection.IterableLike$class;
import scala.collection.Parallelizable$class;
import scala.collection.Seq$class;
import scala.collection.SeqLike$class;
import scala.collection.Traversable$class;
import scala.collection.TraversableLike$class;
import scala.collection.TraversableOnce$class;
import scala.collection.generic.GenericTraversableTemplate$class;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range$;
import scala.collection.parallel.immutable.ParRange;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Range
implements Serializable,
CustomParallelizable<Object, ParRange>,
IndexedSeq<Object> {
    public static final long serialVersionUID;
    private final int start;
    private final int end;
    private final int step;
    private int numRangeElements;
    private int last;
    private volatile int bitmap$priv$0;
    public volatile int bitmap$0;

    static {
        long l = serialVersionUID = 7618862778670199309L;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public int step() {
        return this.step;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int numRangeElements() {
        if ((this.bitmap$priv$0 & 1) != 0) return this.numRangeElements;
        Range range = this;
        synchronized (range) {
            if ((this.bitmap$priv$0 & 1) == 0) {
                this.numRangeElements = Range$.MODULE$.count(this.start(), this.end(), this.step(), this.isInclusive());
                this.bitmap$priv$0 |= 1;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.numRangeElements;
        }
    }

    public Range copy(int start, int end, int step) {
        return new Range(start, end, step);
    }

    public Range by(int step) {
        return this.copy(this.start(), this.end(), step);
    }

    public boolean isInclusive() {
        return false;
    }

    @Override
    public final <U> void foreach(Function1<Object, U> f) {
        if (this.length() > 0) {
            int i;
            int last2 = this.last();
            for (i = this.start(); i != last2; i += this.step()) {
                f.apply(BoxesRunTime.boxToInteger(i));
            }
            f.apply(BoxesRunTime.boxToInteger(i));
        }
    }

    @Override
    public int length() {
        return this.numRangeElements();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int last() {
        if ((this.bitmap$0 & 1) != 0) return this.last;
        Range range = this;
        synchronized (range) {
            if ((this.bitmap$0 & 1) == 0) {
                this.last = this.length() == 0 ? BoxesRunTime.unboxToInt(Nil$.MODULE$.last()) : this.scala$collection$immutable$Range$$locationAfterN(this.length() - 1);
                this.bitmap$0 |= 1;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.last;
        }
    }

    @Override
    public final boolean isEmpty() {
        return this.length() == 0;
    }

    @Override
    public final int apply(int idx) {
        return this.apply$mcII$sp(idx);
    }

    @Override
    public final Range take(int n) {
        return n <= 0 || this.length() == 0 ? this.newEmptyRange(this.start()) : (n >= this.length() ? this : new Inclusive(this.start(), this.scala$collection$immutable$Range$$locationAfterN(n - 1), this.step()));
    }

    @Override
    public final Range drop(int n) {
        return n <= 0 || this.length() == 0 ? this : (n >= this.length() ? this.newEmptyRange(this.end()) : this.copy(this.scala$collection$immutable$Range$$locationAfterN(n), this.end(), this.step()));
    }

    @Override
    public final Range tail() {
        Object object = this.isEmpty() ? Nil$.MODULE$.tail() : BoxedUnit.UNIT;
        return this.drop(1);
    }

    private boolean isWithinBoundaries(int elem) {
        return this.length() > 0 && (this.step() > 0 && this.start() <= elem && elem <= this.last() || this.step() < 0 && this.last() <= elem && elem <= this.start());
    }

    public final int scala$collection$immutable$Range$$locationAfterN(int n) {
        return this.start() + this.step() * n;
    }

    private Range newEmptyRange(int value) {
        return new Range(value, value, this.step());
    }

    @Override
    public final Range reverse() {
        return this.length() > 0 ? new Inclusive(this.last(), this.start(), -this.step()) : this;
    }

    public final boolean contains(int x) {
        return this.isWithinBoundaries(x) && (x - this.start()) % this.step() == 0;
    }

    @Override
    public boolean equals(Object other) {
        Range range;
        Range x;
        Object object = other;
        return object instanceof Range ? (x = (range = (Range)object)).canEqual(this) && this.length() == x.length() && (this.length() == 0 || this.start() == x.start() && this.last() == x.last()) : GenSeqLike$class.equals(this, other);
    }

    @Override
    public String toString() {
        String endStr = this.length() > Range$.MODULE$.MAX_PRINT() ? ", ... )" : ")";
        return this.take(Range$.MODULE$.MAX_PRINT()).mkString("Range(", ", ", endStr);
    }

    public final void foreach$mVc$sp(Function1<Object, BoxedUnit> f) {
        if (this.length() > 0) {
            int i;
            int last2 = this.last();
            for (i = this.start(); i != last2; i += this.step()) {
                f.apply$mcVI$sp(i);
            }
            f.apply$mcVI$sp(i);
        }
    }

    @Override
    public int apply$mcII$sp(int v1) {
        if (v1 < 0 || v1 >= this.length()) {
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(v1)).toString());
        }
        return this.scala$collection$immutable$Range$$locationAfterN(v1);
    }

    public Range(int start, int end, int step) {
        this.start = start;
        this.end = end;
        this.step = step;
        GenTraversableOnce$class.$init$(this);
        TraversableOnce$class.$init$(this);
        Parallelizable$class.$init$(this);
        GenTraversableLike$class.$init$(this);
        TraversableLike$class.$init$(this);
        GenericTraversableTemplate$class.$init$(this);
        GenTraversable$class.$init$(this);
        Traversable$class.$init$(this);
        scala.collection.immutable.Traversable$class.$init$(this);
        GenIterableLike$class.$init$(this);
        GenIterable$class.$init$(this);
        IterableLike$class.$init$(this);
        Iterable$class.$init$(this);
        scala.collection.immutable.Iterable$class.$init$(this);
        Function1$class.$init$(this);
        PartialFunction$class.$init$(this);
        GenSeqLike$class.$init$(this);
        GenSeq$class.$init$(this);
        SeqLike$class.$init$(this);
        Seq$class.$init$(this);
        scala.collection.immutable.Seq$class.$init$(this);
        IndexedSeqLike$class.$init$(this);
        IndexedSeq$class.$init$(this);
        scala.collection.immutable.IndexedSeq$class.$init$(this);
        CustomParallelizable$class.$init$(this);
    }

    public static class Inclusive
    extends Range {
        public boolean isInclusive() {
            return true;
        }

        public Range copy(int start, int end, int step) {
            return new Inclusive(start, end, step);
        }

        public Inclusive(int start, int end, int step) {
            super(start, end, step);
        }
    }
}

